/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.commands.internal.parser;

import com.oracle.jmc.commands.Parameter;
import com.oracle.jmc.commands.Token;
import com.oracle.jmc.commands.internal.parser.ParameterParser;
import com.oracle.jmc.commands.internal.parser.ParserException;
import java.text.ParseException;

final class BooleanParser
extends ParameterParser {
    public static final String ID = "boolean";

    BooleanParser(Parameter parameter) {
        super(parameter);
    }

    @Override
    boolean acceptValue(String value) {
        if (value.equals(Boolean.TRUE.toString())) {
            return true;
        }
        return value.equals(Boolean.FALSE.toString());
    }

    @Override
    protected Object parseValue(Token parameterToken, String text) throws ParseException {
        if (Boolean.TRUE.toString().equals(text)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equals(text)) {
            return Boolean.FALSE;
        }
        throw new ParserException("Boolean value must be true or false.", parameterToken);
    }
}

