/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.commands.internal.executables;

import com.oracle.jmc.commands.IExecute;
import com.oracle.jmc.commands.Statement;
import com.oracle.jmc.core.MCVersion;
import java.io.PrintStream;
import java.util.Properties;

public class ShowVersion
implements IExecute {
    @Override
    public boolean execute(Statement statement, PrintStream out) {
        ShowVersion.showVersion(out);
        return true;
    }

    static void showVersion(PrintStream out) {
        Properties props = MCVersion.getVersionProperties();
        out.println("========================================");
        out.println("Oracle(R) Java Mission Control " + props.getProperty("jmc.version", ""));
        out.println("  java.vm.version = " + System.getProperty("java.vm.version"));
        if (props.size() == 0) {
            out.println("Detailed version information could not be found.");
        } else {
            ShowVersion.dumpProperties(props);
        }
        out.println("========================================");
    }

    protected static void dumpProperties(Properties props) {
        for (Object key : props.keySet()) {
            System.out.println("  " + key + " = " + props.getProperty(key.toString()));
        }
    }
}

