/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.commands.internal.executables;

import com.oracle.jmc.commands.Command;
import com.oracle.jmc.commands.CommandsPlugin;
import com.oracle.jmc.commands.IExecute;
import com.oracle.jmc.commands.Parameter;
import com.oracle.jmc.commands.Statement;
import java.io.PrintStream;

public class Help
implements IExecute {
    private static final String COMMAND_PARAMETER = "command";

    @Override
    public boolean execute(Statement statment, PrintStream writer) {
        if (statment.hasValue(COMMAND_PARAMETER)) {
            String commandName = statment.getString(COMMAND_PARAMETER);
            Command command = CommandsPlugin.getDefault().getCommand(commandName);
            if (command != null) {
                this.printhelpForCommand(writer, command);
            } else {
                this.printUnknownCommand(writer, commandName);
            }
        } else {
            this.printAvailableCommands(writer);
        }
        return false;
    }

    private void printUnknownCommand(PrintStream writer, String commandName) {
        writer.println("No command called " + commandName + ". Type help to see available commands.");
    }

    private void printhelpForCommand(PrintStream writer, Command command) {
        this.printDescription(writer, command);
        this.printUsageDescription(writer, command);
        this.printParameterExplanations(writer, command);
        this.printExample(writer, command);
    }

    private void printParameterExplanations(PrintStream writer, Command command) {
        writer.println();
        for (Parameter p : command.getParameters()) {
            writer.println(String.valueOf(p.getIdentifier()) + " - " + p.getDescription());
        }
        writer.println();
    }

    private void printDescription(PrintStream writer, Command command) {
        if (command.getDesciption() != null) {
            writer.print(String.valueOf(command.getDesciption()) + ' ');
        }
    }

    private void printUsageDescription(PrintStream writer, Command command) {
        writer.println("Usage:");
        writer.println();
        writer.print(String.valueOf(command.getIdentifier()) + ' ');
        for (Parameter p : command.getParameters()) {
            writer.print(String.valueOf(p.getIdentifier()) + ' ');
        }
        writer.println();
    }

    private void printExample(PrintStream writer, Command command) {
        if (command.getParameters().size() > 0) {
            writer.print("E.g, ");
            this.printExampleSimpleNotation(writer, command);
            writer.print(" or ");
            this.printExampleExplicitNotation(writer, command);
            writer.println();
        }
    }

    private void printExampleExplicitNotation(PrintStream writer, Command command) {
        writer.print(command.getIdentifier());
        for (Parameter p : command.getParameters()) {
            if (p.isOptional()) continue;
            writer.print(' ');
            writer.print(String.valueOf(p.getIdentifier()) + "=" + p.getExampleValue());
        }
    }

    private void printExampleSimpleNotation(PrintStream writer, Command command) {
        writer.print(command.getIdentifier());
        for (Parameter p : command.getParameters()) {
            if (p.isOptional()) continue;
            writer.print(' ');
            writer.print(p.getExampleValue());
        }
    }

    private void printAvailableCommands(PrintStream writer) {
        writer.println("Available commands:");
        for (String category : CommandsPlugin.getDefault().getCategories()) {
            writer.println();
            writer.println(category);
            writer.println("==========================");
            for (Command c : CommandsPlugin.getDefault().getCommands(category)) {
                writer.println(String.valueOf(this.padLeftColumn(c.getIdentifier())) + this.descriptionText(c.getDesciption()));
            }
        }
        writer.println();
        writer.print("For more information about a specific command, type ");
        writer.print("help command-name.");
        writer.print(" Multiple commands can be entered, use ';' as a separtor.");
        writer.print(" Commands can also be passed as arguments to jmc, but then the commands needs to prefixed with '-', e.g. -open c:\\recording.jfr -selectgroup code -selecttab hotMethods");
        writer.println();
    }

    private String padLeftColumn(String identifier) {
        String pad = "                  ";
        return String.valueOf(identifier) + pad.substring(Math.min(pad.length(), identifier.length()));
    }

    private String descriptionText(String description) {
        return description == null ? "" : description;
    }
}

