/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.commands;

import com.oracle.jmc.commands.CommandsPlugin;
import com.oracle.jmc.commands.Parameter;

public final class Value {
    private final Parameter m_parameter;
    private final Object m_valueObject;
    private final int m_position;

    public Value(Parameter parameter, Object valueObject, int position) {
        this.m_parameter = parameter;
        this.m_valueObject = valueObject;
        this.m_position = position;
    }

    static Object resolve(Object valueName) {
        if (valueName instanceof String && ((String)valueName).startsWith("$")) {
            return CommandsPlugin.getDefault().getEnvironmentVariable((String)valueName);
        }
        return valueName;
    }

    public Parameter getParameter() {
        return this.m_parameter;
    }

    public Object getObject() {
        return Value.resolve(this.m_valueObject);
    }

    public int getPosition() {
        return this.m_position;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParameter().getIdentifier());
        builder.append("=");
        builder.append(String.valueOf(this.getObject()));
        return builder.toString();
    }
}

