/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.commands;

import com.oracle.jmc.commands.Command;
import com.oracle.jmc.commands.IExecute;
import com.oracle.jmc.commands.Value;
import java.io.PrintStream;
import java.util.List;

public final class Statement {
    private final Command m_command;
    private final List<Value> m_parameters;

    public Statement(Command command, List<Value> values) {
        this.m_command = command;
        this.m_parameters = values;
    }

    public Command getCommand() {
        return this.m_command;
    }

    public List<Value> getValues() {
        return this.m_parameters;
    }

    void execute(PrintStream out) throws RuntimeException {
        IExecute executable = this.getCommand().createExecutableStatement();
        executable.execute(this, out);
    }

    public Number getNumber(String valueName) {
        return (Number)this.getValue(valueName).getObject();
    }

    public String getString(String valueName) {
        return (String)this.getValue(valueName).getObject();
    }

    public Boolean getBoolean(String valueName) {
        return (Boolean)this.getValue(valueName).getObject();
    }

    public Value getValue(String valueName) {
        Value value = this.getSafeValue(valueName);
        if (value != null) {
            return value;
        }
        throw new RuntimeException("Unknown value name " + valueName);
    }

    public boolean hasValue(String valueName) {
        return this.getSafeValue(valueName) != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getCommand().getIdentifier());
        builder.append("(");
        List<Value> values = this.getValues();
        int n = 0;
        while (n < values.size()) {
            builder.append(String.valueOf(values.get(n).getObject()));
            if (n < values.size() - 1) {
                builder.append(", ");
            }
            ++n;
        }
        builder.append(")");
        return builder.toString();
    }

    private Value getSafeValue(String valueName) {
        for (Value v : this.getValues()) {
            if (!valueName.equals(v.getParameter().getIdentifier())) continue;
            return v;
        }
        return null;
    }
}

