/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.commands;

import com.oracle.jmc.commands.ICommandHelper;
import com.oracle.jmc.commands.IExecute;
import com.oracle.jmc.commands.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;

public final class Command
implements Comparable<Command> {
    private final List<Parameter> m_parameters = new ArrayList<Parameter>();
    private String m_identifier;
    private String m_description;
    private String m_name;
    private IConfigurationElement m_classElement;
    private ICommandHelper m_commandHelper;
    private String m_category = "";

    Command() {
    }

    public String getName() {
        return this.m_name;
    }

    public String getDesciption() {
        return this.m_description;
    }

    public ICommandHelper getCommandHelp() {
        return this.m_commandHelper;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public List<Parameter> getParameters() {
        return this.m_parameters;
    }

    void setName(String name) {
        this.m_name = name;
    }

    void setDescription(String description) {
        this.m_description = description;
    }

    public String getCategory() {
        return this.m_category;
    }

    void setCategory(String category) {
        this.m_category = category;
    }

    void setIdentifier(String identifier) {
        this.m_identifier = identifier;
    }

    void addParameter(Parameter parameter) {
        this.m_parameters.add(parameter);
    }

    void setCommandHelper(ICommandHelper typeCompletion) {
        this.m_commandHelper = typeCompletion;
    }

    void setClassConfigurationElement(IConfigurationElement element) {
        this.m_classElement = element;
    }

    IExecute createExecutableStatement() {
        if (this.m_classElement == null) {
            throw new RuntimeException("No registered IExcutable for statement");
        }
        try {
            return (IExecute)this.m_classElement.createExecutableExtension("class");
        }
        catch (InvalidRegistryObjectException ie) {
            throw new RuntimeException("Could not execute " + this.getIdentifier(), ie);
        }
        catch (CoreException e) {
            throw new RuntimeException("Could not execute " + this.getIdentifier(), e);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.m_identifier);
        result.append("(");
        List<Parameter> parameters = this.getParameters();
        int n = 0;
        while (n < parameters.size()) {
            result.append(parameters.get(n).getIdentifier());
            if (n != parameters.size() - 1) {
                result.append(", ");
            }
            ++n;
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public int compareTo(Command command) {
        return this.getIdentifier().compareTo(command.getIdentifier());
    }

    public boolean equals(Object object) {
        if (object instanceof Command) {
            return this.getIdentifier().equals(((Command)object).getIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public int getNonOptionalParameterCount() {
        int count = 0;
        for (Parameter p : this.getParameters()) {
            if (p.isOptional()) continue;
            ++count;
        }
        return count;
    }
}

