/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SafeThreadFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class NativeLibraryBundle {
    private static File rootDir;
    private static final String LOCK_SUFFIX = ".lck";
    private static Attributes.Name independentLibsAttribute;
    private static Set<String> dirsCreatedByThisJVM;
    private File lockFile;
    private FileLockWrapper lock;
    private String dirName;
    private Map<String, String> libNameMap = new HashMap<String, String>();
    private File destination = null;
    static Map<String, NativeLibraryBundle> originFileLocks;

    public synchronized String get(String string) {
        return this.libNameMap.get(string.toLowerCase());
    }

    private synchronized void put(String string, String string2) {
        this.libNameMap.put(string.toLowerCase(), string2);
    }

    protected void finalize() {
        NativeLibraryBundle.releaseLocksOfOriginals(this);
        if (NativeLibraryBundle.deleteRecursively(new File(rootDir, this.dirName))) {
            this.lock.release();
            NativeLibraryBundle.deleteFile(this.lockFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized File getDestinationDir() throws IOException {
        if (this.destination == null) {
            Set<String> set = dirsCreatedByThisJVM;
            synchronized (set) {
                this.lockFile = File.createTempFile("tmp", LOCK_SUFFIX, rootDir);
                String string = this.lockFile.getName();
                this.dirName = string.substring(0, string.lastIndexOf(LOCK_SUFFIX));
                dirsCreatedByThisJVM.add(this.dirName);
            }
            this.lock = FileLockWrapper.lockFile(this.lockFile);
            this.destination = new File(rootDir, this.dirName);
            NativeLibraryBundle.makeDir(this.destination);
        }
        return this.destination;
    }

    private static synchronized boolean tryLockOriginalCopy(File file, boolean bl, NativeLibraryBundle nativeLibraryBundle) {
        String string = bl ? file.getParent() : file.getAbsolutePath();
        NativeLibraryBundle nativeLibraryBundle2 = originFileLocks.get(string);
        if (nativeLibraryBundle2 == null) {
            originFileLocks.put(file.getParent(), nativeLibraryBundle);
            return true;
        }
        return nativeLibraryBundle2 == nativeLibraryBundle;
    }

    private static synchronized void releaseLocksOfOriginals(NativeLibraryBundle nativeLibraryBundle) {
        Iterator<Map.Entry<String, NativeLibraryBundle>> iterator = originFileLocks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, NativeLibraryBundle> entry = iterator.next();
            if (entry.getValue() == nativeLibraryBundle) continue;
            iterator.remove();
        }
    }

    private void processLib(Manifest manifest, File file, boolean bl) throws IOException {
        String string = null;
        if (!NativeLibraryBundle.tryLockOriginalCopy(file, bl, this)) {
            Trace.println("Failed to grab lock for " + file, TraceLevel.CACHE);
            string = this.copyLib(file);
        } else {
            string = file.getAbsolutePath();
        }
        this.put(file.getName(), string);
    }

    public void prepareLibrary(String string, JarFile jarFile, String string2) throws IOException {
        Attributes attributes;
        Manifest manifest = jarFile.getManifest();
        Attributes attributes2 = attributes = manifest != null ? manifest.getMainAttributes() : null;
        if (attributes != null && "true".equals(attributes.get(independentLibsAttribute))) {
            Trace.println("Lock individual library " + string, TraceLevel.CACHE);
            File file = new File(string2, string);
            this.processLib(manifest, file, false);
        } else {
            File file = new File(string2);
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.processLib(manifest, fileArray[i], true);
            }
        }
    }

    private String copyLib(File file) throws IOException {
        String string;
        if (file.isFile() && ((string = file.getName()).endsWith(Platform.get().getLibrarySufix()) || OSType.isMac() && string.endsWith(".jnilib"))) {
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            File file2 = new File(this.getDestinationDir(), file.getName());
            FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
            fileChannel2.force(true);
            fileChannel.close();
            fileChannel2.close();
            return file2.getAbsolutePath();
        }
        return null;
    }

    private static void deleteOldDirs() {
        File[] fileArray = rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (dirsCreatedByThisJVM.contains(file.getName())) continue;
            File file2 = new File(rootDir, file.getName() + LOCK_SUFFIX);
            try {
                boolean bl;
                FileLockWrapper fileLockWrapper = FileLockWrapper.tryLockFile(file2);
                if (fileLockWrapper == null || !(bl = NativeLibraryBundle.deleteRecursively(file))) continue;
                fileLockWrapper.release();
                NativeLibraryBundle.deleteFile(file2);
                continue;
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
    }

    private static void deleteFile(File file) {
        if (!file.delete()) {
            Trace.print("Failed to delete file " + file.getAbsolutePath());
        }
    }

    private static void makeDir(File file) {
        if (!file.mkdir()) {
            Trace.print("Failed to create directory " + file.getAbsolutePath());
        }
    }

    private static boolean deleteRecursively(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                NativeLibraryBundle.deleteRecursively(file2);
                continue;
            }
            NativeLibraryBundle.deleteFile(file2);
        }
        return file.delete();
    }

    static {
        independentLibsAttribute = new Attributes.Name("IndependentLibraries");
        dirsCreatedByThisJVM = Collections.synchronizedSet(new HashSet());
        String string = System.getProperty("java.io.tmpdir") + File.separator + ".java_jnlp_applet_nativelib_cache." + System.getProperty("user.name");
        rootDir = new File(string);
        if (!rootDir.exists()) {
            NativeLibraryBundle.makeDir(rootDir);
        }
        Thread thread = SafeThreadFactory.createThread(new Runnable(){

            @Override
            public void run() {
                NativeLibraryBundle.deleteOldDirs();
            }
        });
        thread.setName("Native Library Cache Cleaner Thread");
        thread.setDaemon(true);
        thread.start();
        originFileLocks = new HashMap<String, NativeLibraryBundle>();
    }

    static class FileLockWrapper {
        private FileChannel chan;
        private FileLock lock;

        private FileLockWrapper(FileChannel fileChannel, FileLock fileLock) {
            this.chan = fileChannel;
            this.lock = fileLock;
        }

        public void release() {
            try {
                this.lock.release();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            try {
                this.chan.close();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }

        public static FileLockWrapper lockFile(File file) throws IOException {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileChannel fileChannel = fileOutputStream.getChannel();
            FileLock fileLock = fileChannel.lock();
            if (fileLock == null) {
                fileChannel.close();
                return null;
            }
            return new FileLockWrapper(fileChannel, fileLock);
        }

        public static FileLockWrapper tryLockFile(File file) throws IOException {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileChannel fileChannel = fileOutputStream.getChannel();
            FileLock fileLock = fileChannel.tryLock();
            if (fileLock == null) {
                fileChannel.close();
                return null;
            }
            return new FileLockWrapper(fileChannel, fileLock);
        }
    }
}

