/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DeployJavaUtilJarAccess {
    private static final String PKG_PREFIX = "jdk.internal.misc";
    private static final String LEGACY_PKG_PREFIX = "sun.misc";
    private final Object javaUtilJarAccess;
    private final Method jarFileHasClassPathAttributeMethod;
    private final Method getCodeSourcesMethod;
    private final Method getCodeSourceMethod;
    private final Method entryNamesMethod;
    private final Method entries2Method;
    private final Method setEagerValidationMethod;
    private final Method getManifestDigestsMethod;
    private final Method getRealNameMethod;
    private static DeployJavaUtilJarAccess instance;

    private DeployJavaUtilJarAccess() throws ReflectiveOperationException {
        Class<?> clazz = this.getJDKClass("JavaUtilJarAccess");
        Method method = this.getJDKClass("SharedSecrets").getDeclaredMethod("javaUtilJarAccess", new Class[0]);
        this.javaUtilJarAccess = method.invoke(null, new Object[0]);
        this.jarFileHasClassPathAttributeMethod = clazz.getDeclaredMethod("jarFileHasClassPathAttribute", JarFile.class);
        this.getCodeSourcesMethod = clazz.getDeclaredMethod("getCodeSources", JarFile.class, URL.class);
        this.getCodeSourceMethod = clazz.getDeclaredMethod("getCodeSource", JarFile.class, URL.class, String.class);
        this.entryNamesMethod = clazz.getDeclaredMethod("entryNames", JarFile.class, CodeSource[].class);
        this.entries2Method = clazz.getDeclaredMethod("entries2", JarFile.class);
        this.setEagerValidationMethod = clazz.getDeclaredMethod("setEagerValidation", JarFile.class, Boolean.TYPE);
        this.getManifestDigestsMethod = clazz.getDeclaredMethod("getManifestDigests", JarFile.class);
        this.getRealNameMethod = Config.isJavaVersionAtLeast9() && !Config.isJavaVersionAtLeast10() ? clazz.getDeclaredMethod("getRealName", JarFile.class, JarEntry.class) : null;
    }

    private Class<?> getJDKClass(String string) throws ClassNotFoundException {
        try {
            return Class.forName("jdk.internal.misc." + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName("sun.misc." + string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                classNotFoundException.addSuppressed(classNotFoundException2);
                throw classNotFoundException;
            }
        }
    }

    public static synchronized DeployJavaUtilJarAccess instance() {
        try {
            if (instance == null) {
                instance = new DeployJavaUtilJarAccess();
            }
            return instance;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public boolean jarFileHasClassPathAttribute(JarFile jarFile) throws IOException {
        try {
            return (Boolean)this.jarFileHasClassPathAttributeMethod.invoke(this.javaUtilJarAccess, jarFile);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof IOException) {
                throw (IOException)invocationTargetException.getTargetException();
            }
            DeployJavaUtilJarAccess.rethrowCause(invocationTargetException);
            return false;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public CodeSource[] getCodeSources(JarFile jarFile, URL uRL) {
        try {
            return (CodeSource[])this.getCodeSourcesMethod.invoke(this.javaUtilJarAccess, jarFile, uRL);
        }
        catch (InvocationTargetException invocationTargetException) {
            DeployJavaUtilJarAccess.rethrowCause(invocationTargetException);
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public CodeSource getCodeSource(JarFile jarFile, URL uRL, String string) {
        try {
            return (CodeSource)this.getCodeSourceMethod.invoke(this.javaUtilJarAccess, jarFile, uRL, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            DeployJavaUtilJarAccess.rethrowCause(invocationTargetException);
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public Enumeration<String> entryNames(JarFile jarFile, CodeSource[] codeSourceArray) {
        try {
            return (Enumeration)this.entryNamesMethod.invoke(this.javaUtilJarAccess, jarFile, codeSourceArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            DeployJavaUtilJarAccess.rethrowCause(invocationTargetException);
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public Enumeration<JarEntry> entries2(JarFile jarFile) {
        try {
            return (Enumeration)this.entries2Method.invoke(this.javaUtilJarAccess, jarFile);
        }
        catch (InvocationTargetException invocationTargetException) {
            DeployJavaUtilJarAccess.rethrowCause(invocationTargetException);
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public void setEagerValidation(JarFile jarFile, boolean bl) {
        try {
            this.setEagerValidationMethod.invoke(this.javaUtilJarAccess, jarFile, bl);
        }
        catch (InvocationTargetException invocationTargetException) {
            DeployJavaUtilJarAccess.rethrowCause(invocationTargetException);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public String getRealName(JarFile jarFile, JarEntry jarEntry) {
        if (this.getRealNameMethod == null) {
            throw new InternalError("Should be called in Java 9 and up");
        }
        try {
            return (String)this.getRealNameMethod.invoke(this.javaUtilJarAccess, jarFile, jarEntry);
        }
        catch (InvocationTargetException invocationTargetException) {
            DeployJavaUtilJarAccess.rethrowCause(invocationTargetException);
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public List<Object> getManifestDigests(JarFile jarFile) {
        try {
            return (List)this.getManifestDigestsMethod.invoke(this.javaUtilJarAccess, jarFile);
        }
        catch (InvocationTargetException invocationTargetException) {
            DeployJavaUtilJarAccess.rethrowCause(invocationTargetException);
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    private static void rethrowCause(InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new AssertionError((Object)invocationTargetException);
    }
}

