/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Platform;
import com.sun.deploy.net.DownloadException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CertificateDialog;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.FancyButton;
import com.sun.deploy.ui.JSmartTextArea;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.ui.UITextArea;
import com.sun.deploy.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.Certificate;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class MoreInfoDialog
extends JDialog {
    private static final long serialVersionUID = 1732843154120581169L;
    private FancyButton details;
    private String[] alerts;
    private String[] infos;
    private int securityInfoCount;
    private Certificate[] certs;
    private int start;
    private int end;
    private boolean majorWarning;
    private boolean sandboxApp = false;
    private boolean nativeSandbox = false;
    private Throwable throwable = null;
    private final String WARNING_ICON = "icon-warning16.png";
    private final String INFO_ICON = "icon-info16.png";
    private final int VERTICAL_STRUT = 18;
    private final int HORIZONTAL_STRUT = 12;
    private final String linkUrlStr = "http://java.com/en/download/faq/self_signed.xml";
    private final int TEXT_WIDTH = 326;

    MoreInfoDialog(JDialog jDialog, String[] stringArray, String[] stringArray2, int n, Certificate[] certificateArray, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        super((Dialog)jDialog, true);
        this.alerts = stringArray;
        this.infos = stringArray2;
        this.securityInfoCount = n;
        this.certs = certificateArray;
        this.start = n2;
        this.end = n3;
        this.majorWarning = bl;
        this.sandboxApp = bl2;
        this.nativeSandbox = bl3;
        this.initComponents(null, null);
        this.setResizable(false);
        if (jDialog != null && jDialog.isAlwaysOnTop()) {
            this.setAlwaysOnTop(true);
        }
    }

    MoreInfoDialog(JDialog jDialog, String string, Throwable throwable, Certificate[] certificateArray, boolean bl) {
        super((Dialog)jDialog, true);
        this.certs = certificateArray;
        this.start = 0;
        this.end = certificateArray == null ? 0 : certificateArray.length;
        this.majorWarning = bl;
        this.throwable = throwable;
        this.initComponents(string, throwable);
        if (jDialog != null && jDialog.isAlwaysOnTop()) {
            this.setAlwaysOnTop(true);
        }
    }

    private void initComponents(String string, Throwable throwable) {
        this.setTitle(this.getMessage("security.more.info.title"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 12, 16));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        if (string != null) {
            JPanel jPanel2 = this.createDetailPanel(string);
            jPanel.add(jPanel2);
        } else if (throwable != null) {
            jPanel.add(Box.createHorizontalStrut(440));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(ResourceManager.getString("exception.details.label"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
            jPanel3.add((Component)jLabel, "West");
            jPanel.add(jPanel3);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            JTextArea jTextArea = new JTextArea(stringWriter.toString(), 20, 60);
            jTextArea.setFont(ResourceManager.getUIFont());
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
            jPanel.add(jScrollPane);
            if (this.certs != null) {
                jPanel.add(Box.createVerticalStrut(18));
                jPanel.add(this.getLinkPanel());
            }
        } else {
            jPanel.add(this.getSecurityPanel());
            if (this.certs != null) {
                jPanel.add(this.getLinkPanel());
            }
            if (this.nativeSandbox) {
                JPanel jPanel4 = this.createNativeSandboxPanel();
                jPanel.add(jPanel4);
            }
            jPanel.add(Box.createVerticalStrut(18));
            jPanel.add(this.getIntegrationPanel());
        }
        jPanel.add(Box.createVerticalStrut(18));
        jPanel.add(this.getBtnPanel());
        this.getContentPane().add((Component)jPanel, "Center");
        this.pack();
        UIFactory.placeWindow(this);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MoreInfoDialog.this.dismissAction();
            }
        });
    }

    private JPanel getSecurityPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        int n = this.alerts == null ? 0 : this.alerts.length;
        jPanel.add(this.blockPanel("icon-warning16.png", this.alerts, 0, n));
        String string = null;
        if (n == 0) {
            string = "icon-info16.png";
        }
        n = this.securityInfoCount;
        jPanel.add(this.blockPanel(string, this.infos, 0, n));
        return jPanel;
    }

    private JPanel getLinkPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(Box.createHorizontalGlue());
        String string = this.sandboxApp ? "sandbox.security.more.info.details" : "security.more.info.details";
        this.details = new FancyButton(ResourceManager.getString(string), ResourceManager.getMnemonic(string), Color.blue);
        this.details.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getComponent() instanceof FancyButton) {
                    MoreInfoDialog.this.showCertDetails();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.details.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MoreInfoDialog.this.showCertDetails();
            }
        });
        jPanel.add(this.details);
        return jPanel;
    }

    private JPanel getIntegrationPanel() {
        int n = this.securityInfoCount;
        int n2 = this.infos == null ? 0 : this.infos.length;
        return this.blockPanel("icon-info16.png", this.infos, n, n2);
    }

    private JPanel getBtnPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(this.getMessage("common.close_btn"));
        jButton.setAlignmentY(0.0f);
        jButton.setAlignmentX(0.0f);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MoreInfoDialog.this.dismissAction();
            }
        });
        this.getRootPane().setDefaultButton(jButton);
        if (this.majorWarning) {
            String string = "security.more.info.linkurl";
            FancyButton fancyButton = new FancyButton(ResourceManager.getString(string), ResourceManager.getMnemonic(string));
            fancyButton.setAlignmentY(0.0f);
            fancyButton.setAlignmentX(0.0f);
            fancyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Platform.get().showDocument("http://java.com/en/download/faq/self_signed.xml");
                }
            });
            jPanel.add(fancyButton);
            jPanel.add(Box.createHorizontalStrut(95));
        }
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel blockPanel(String string, String[] stringArray, int n, int n2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (stringArray != null) {
            for (int i = n; i < n2; ++i) {
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BoxLayout(jPanel2, 0));
                jPanel2.setAlignmentX(0.0f);
                JLabel jLabel = new JLabel();
                if (i == n && string != null) {
                    jLabel.setIcon(ResourceManager.getIconResource(string));
                } else {
                    jLabel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
                }
                jLabel.setAlignmentY(0.0f);
                jLabel.setAlignmentX(0.0f);
                UITextArea uITextArea = new UITextArea(new JLabel().getFont().getSize(), 326, false);
                uITextArea.setSelectable();
                uITextArea.setText(stringArray[i]);
                Dimension dimension = uITextArea.getPreferredSize();
                uITextArea.setSize(dimension.width, dimension.height);
                uITextArea.setAlignmentY(0.0f);
                uITextArea.setAlignmentX(0.0f);
                jPanel2.add(jLabel);
                jPanel2.add(Box.createHorizontalStrut(12));
                jPanel2.add(uITextArea);
                jPanel2.add(Box.createHorizontalGlue());
                jPanel.add(jPanel2);
                jPanel.add(Box.createVerticalStrut(18));
            }
        }
        return jPanel;
    }

    private JPanel createNativeSandboxPanel() {
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Platform.get().showDocument(hyperlinkEvent.getURL().toString());
                    }
                    catch (Exception exception) {
                        Trace.ignored(exception);
                    }
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel();
        jLabel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalStrut(12));
        jPanel.add(DialogTemplate.createYellowWarningPanel(this.getMessage("security.moreinfo.native.sandbox.warning"), hyperlinkListener, 330));
        jPanel.add(Box.createHorizontalGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jPanel);
        jPanel2.add(Box.createVerticalStrut(18));
        return jPanel2;
    }

    private void showCertDetails() {
        CertificateDialog.showCertificates(this, this.certs, this.start, this.end);
    }

    private void dismissAction() {
        this.setVisible(false);
        this.dispose();
    }

    private String getMessage(String string) {
        return ResourceManager.getString(string);
    }

    private String getErrorComponent() {
        String string = null;
        if (this.throwable instanceof DownloadException) {
            DownloadException downloadException = (DownloadException)this.throwable;
            string = downloadException.getResourceString();
        }
        return string;
    }

    private String getReasonString() {
        String string = null;
        if (this.throwable instanceof BlockedException) {
            BlockedException blockedException = (BlockedException)this.throwable;
            string = blockedException.getReason();
        } else if (this.throwable != null) {
            string = this.throwable.getMessage();
        }
        return string;
    }

    private JPanel createLabelsPanel() {
        JComponent jComponent;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = new JLabel();
        Font font = jLabel.getFont().deriveFont(1);
        Font font2 = jLabel.getFont().deriveFont(0);
        String string = this.getReasonString();
        String string2 = this.getErrorComponent();
        if (string2 != null) {
            jComponent = new JLabel(this.getMessage("deployment.ssv.component"));
            jComponent.setFont(font);
            JLabel jLabel2 = new JLabel();
            jLabel2.setFont(font2);
            jLabel2.putClientProperty("html.disable", Boolean.TRUE);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(12, 0, 0, 12);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel.add(jComponent);
            gridBagConstraints.insets = new Insets(12, 0, 0, 12);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            jLabel2.setText(string2);
            jPanel.add(jLabel2);
        }
        if (string != null) {
            jComponent = new JSmartTextArea(string);
            ((JTextArea)jComponent).setFont(font2);
            ((JTextArea)jComponent).setLineWrap(true);
            ((JTextArea)jComponent).setWrapStyleWord(true);
            jComponent.setOpaque(false);
            int n = ((JSmartTextArea)jComponent).getPreferredSize().height * 3;
            jComponent.setPreferredSize(new Dimension(((JSmartTextArea)jComponent).getPreferredSize().width, n));
            gridBagConstraints.insets = new Insets(12, 0, 0, 12);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel.add(jComponent);
        }
        return jPanel;
    }

    private JPanel createDetailPanel(String string) {
        String[] stringArray;
        JPanel jPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(480, 300);
            }
        };
        jPanel.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, "Center");
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(ResourceManager.getString("launcherrordialog.error.label"));
        Font font = jLabel.getFont().deriveFont(1);
        jLabel.setFont(font);
        JPanel jPanel3 = this.createLabelsPanel();
        jPanel2.add((Component)jPanel3, "West");
        try {
            stringArray = string.split("<split>");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            stringArray = StringUtils.splitString(string, "<split>");
        }
        jPanel.add((Component)jPanel2, "North");
        int n = 1;
        while (n + 1 < stringArray.length) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setFont(ResourceManager.getUIFont());
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setText(stringArray[n + 1]);
            jTabbedPane.add(stringArray[n], new JScrollPane(jTextArea));
            n += 2;
        }
        return jPanel;
    }
}

