/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.si;

import com.sun.deploy.config.Platform;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;

public class SingleInstanceManager {
    private static final boolean DEBUG = false;
    private static String _idString;
    private static int _currPort;
    private static String _randomNumberString;
    private static String _openPrintFilePath;
    private static String _actionName;
    static final int ENCODING_PLATFORM = 1;
    static final int ENCODING_UNICODE = 2;
    static final String ENCODING_PLATFORM_NAME = "UTF-8";
    static final String ENCODING_UNICODE_NAME = "UTF-16LE";

    public static void setActionName(String string) {
        if (string == null || string.equals("-open") || string.equals("-print")) {
            _actionName = string;
        }
    }

    public static String getActionName() {
        return _actionName;
    }

    public static void setOpenPrintFilePath(String string) {
        _openPrintFilePath = string;
    }

    public static String getOpenPrintFilePath() {
        return _openPrintFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerRunning(String string) {
        File file = new File(SingleInstanceImpl.SI_FILEDIR);
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(SingleInstanceImpl.getSingleInstanceFilePrefix(string + Platform.get().getSessionSpecificString()))) continue;
                try {
                    _currPort = Integer.parseInt(stringArray[i].substring(stringArray[i].lastIndexOf(95) + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    Trace.ignoredException(numberFormatException);
                    return false;
                }
                Trace.println("server running at port: " + _currPort);
                File file2 = new File(SingleInstanceImpl.SI_FILEDIR, stringArray[i]);
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new FileReader(file2));
                    _randomNumberString = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                    }
                }
                _idString = string;
                return true;
            }
        }
        return false;
    }

    public static boolean connectToServer(String string) {
        Trace.println("connect to: " + _idString + " " + _currPort, TraceLevel.TEMP);
        if (_randomNumberString == null) {
            Trace.println("MAGIC number is null, bail out", TraceLevel.TEMP);
            return false;
        }
        try {
            Socket socket = new Socket("127.0.0.1", _currPort);
            OutputStream outputStream = socket.getOutputStream();
            byte[] byArray = new byte[]{1};
            outputStream.write(byArray);
            String string2 = Charset.defaultCharset().name();
            PrintStream printStream = new PrintStream(outputStream, true, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), string2));
            printStream.println(_randomNumberString);
            String string3 = SingleInstanceManager.getOpenPrintFilePath();
            String string4 = SingleInstanceManager.getActionName();
            if (string3 != null && string4 != null) {
                printStream.println("javaws.singleinstance.init.openprint");
                printStream.println(string4);
                printStream.println(string3);
            } else {
                printStream.println("javaws.singleinstance.init");
                printStream.println(string);
            }
            printStream.println("EOF");
            printStream.flush();
            Trace.println("waiting for ack", TraceLevel.TEMP);
            int n = 5;
            for (int i = 0; i < n; ++i) {
                String string5 = bufferedReader.readLine();
                if (string5 == null || !string5.equals("javaws.singleinstance.ack")) continue;
                Trace.println("GOT ACK", TraceLevel.TEMP);
                socket.close();
                return true;
            }
            socket.close();
        }
        catch (ConnectException connectException) {
            Trace.println("no server is running - continue launch!", TraceLevel.TEMP);
            return false;
        }
        catch (SocketException socketException) {
            Trace.println("no server is running - continue launch!", TraceLevel.TEMP);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Trace.println("no ACK from server, bail out", TraceLevel.TEMP);
        return false;
    }

    static {
        _randomNumberString = null;
        _openPrintFilePath = null;
        _actionName = null;
    }
}

