/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.TrustDeciderDialog;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;

class X509Util {
    private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";

    X509Util() {
    }

    static Principal getIssuerPrincipal(Certificate certificate) {
        try {
            return ((X509Certificate)certificate).getIssuerX500Principal();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Trace.println("NoSuchMethodError: X509Certificate.getIssuerX500Principal(): " + noSuchMethodError, TraceLevel.SECURITY);
            return ((X509Certificate)certificate).getIssuerDN();
        }
    }

    static Principal getSubjectPrincipal(Certificate certificate) {
        try {
            return ((X509Certificate)certificate).getSubjectX500Principal();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Trace.println("NoSuchMethodError: X509Certificate.getSubjectX500Principal(): " + noSuchMethodError, TraceLevel.SECURITY);
            return ((X509Certificate)certificate).getSubjectDN();
        }
    }

    static List<String> getExtendedKeyUsage(Certificate certificate) throws CertificateParsingException {
        return ((X509Certificate)certificate).getExtendedKeyUsage();
    }

    static int showSecurityDialog(Certificate[] certificateArray, URL uRL, int n, int n2, boolean bl, int n3, Date date, AppInfo appInfo, boolean bl2) throws CertificateException {
        int n4 = TrustDeciderDialog.showDialog(certificateArray, uRL, n, n2, bl, n3, date, appInfo, false, null, bl2);
        return n4;
    }
}

