/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertStore;
import com.sun.deploy.trace.Trace;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.PropertyPermission;
import java.util.Set;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.DistributionPointFetcher;
import sun.security.provider.certpath.OCSP;
import sun.security.x509.X509CRLEntryImpl;

class RevocationChecker {
    private final X509Certificate anchor;
    private final Date date;
    private final String sigProvider;
    private final boolean checkOCSP;
    private final boolean checkCRLs;
    private final boolean checkBoth;
    private URI ocspResponderURI;
    private final X509Certificate ocspResponderCert;
    private final boolean onlyPublisher;
    private final X509CRL configCrl;
    private final Date timestamp;
    private long maxClockSkew = 900000L;
    private X509Certificate issuerCert;
    private boolean certCanSignCRL = true;
    private String variant;
    private static final AccessControlContext ACC_PROP_INSTANCE;
    private static final boolean[] ALL_REASONS;
    private static Class<?>[] PARAMS;
    private static Class<?>[] TYPES;

    RevocationChecker(X509Certificate x509Certificate, PKIXParameters pKIXParameters, final boolean bl, final boolean bl2, String string, X509Certificate x509Certificate2, boolean bl3, X509CRL x509CRL, Date date, final String string2, final String string3, String string4) {
        if (!bl && !bl2) {
            throw new IllegalArgumentException();
        }
        this.date = pKIXParameters.getDate();
        this.sigProvider = pKIXParameters.getSigProvider();
        this.anchor = x509Certificate;
        this.issuerCert = x509Certificate;
        this.checkOCSP = bl;
        this.checkCRLs = bl2;
        this.checkBoth = bl && bl2;
        this.variant = string4;
        if (string != null) {
            try {
                this.ocspResponderURI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                Trace.securityPrintln("Can't parse OCSP responder URI: " + this.ocspResponderURI);
                Trace.ignored(uRISyntaxException);
            }
        }
        this.ocspResponderCert = x509Certificate2;
        this.onlyPublisher = bl3;
        this.configCrl = x509CRL;
        this.timestamp = date;
        if (string3 != null) {
            try {
                this.maxClockSkew = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Trace.ignored(numberFormatException);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (bl) {
                    if (string2 != null) {
                        System.setProperty("com.sun.security.ocsp.timeout", string2);
                    }
                    if (string3 != null) {
                        System.setProperty("com.sun.security.ocsp.clockSkew", string3);
                    }
                }
                if (bl2) {
                    System.setProperty("com.sun.security.enableCRLDP", "true");
                    if (string2 != null) {
                        System.setProperty("com.sun.security.crl.timeout", string2);
                    }
                    System.setProperty("sun.security.certpath.ldap.disable.app.resource.files", "true");
                }
                return null;
            }
        }, ACC_PROP_INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void check(X509Certificate x509Certificate, boolean bl) throws CertificateException {
        try {
            if (this.onlyPublisher && x509Certificate.getBasicConstraints() != -1) {
                Trace.securityPrintln("Skipping revocation check, not publisher cert");
                return;
            }
            if (this.checkOCSP) {
                this.checkOCSP(x509Certificate);
            } else if (this.checkCRLs) {
                this.checkCRLs(x509Certificate, bl);
            }
        }
        catch (CertificateException certificateException) {
            if (!this.checkBoth || certificateException instanceof CertificateRevokedException) {
                throw certificateException;
            }
            CertificateException certificateException2 = certificateException;
            Trace.securityPrintln("Failing over to CRLs: " + certificateException.getMessage());
            try {
                this.checkCRLs(x509Certificate, bl);
            }
            catch (CertificateException certificateException3) {
                if (certificateException3 instanceof CertificateRevokedException) {
                    throw certificateException3;
                }
                certificateException2.addSuppressed(certificateException3);
                throw certificateException2;
            }
        }
        finally {
            this.updateState(x509Certificate);
        }
    }

    private void updateState(X509Certificate x509Certificate) {
        this.issuerCert = x509Certificate;
        this.certCanSignCRL = RevocationChecker.certCanSignCRL(x509Certificate);
    }

    private static boolean certCanSignCRL(X509Certificate x509Certificate) {
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            return blArray[6];
        }
        return false;
    }

    private void checkOCSP(X509Certificate x509Certificate) throws CertificateException {
        URI uRI;
        URI uRI2 = uRI = this.ocspResponderURI != null ? this.ocspResponderURI : OCSP.getResponderURI(x509Certificate);
        if (uRI == null) {
            throw new StatusUnknownException("Certificate does not specify OCSP responder");
        }
        X509Certificate x509Certificate2 = this.ocspResponderCert != null ? this.ocspResponderCert : this.issuerCert;
        try {
            OCSP.RevocationStatus revocationStatus = this.doPrivilegedOCSPCheck(x509Certificate, uRI, x509Certificate2);
            Trace.securityPrintln("OCSP Response: " + (Object)((Object)revocationStatus.getCertStatus()));
            if (revocationStatus.getCertStatus() == OCSP.RevocationStatus.CertStatus.REVOKED) {
                throw new CertificateRevokedException(revocationStatus.getRevocationTime(), revocationStatus.getRevocationReason(), x509Certificate2.getSubjectX500Principal(), revocationStatus.getSingleExtensions());
            }
            if (revocationStatus.getCertStatus() == OCSP.RevocationStatus.CertStatus.UNKNOWN) {
                throw new StatusUnknownException();
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof IOException) {
                throw new StatusUnknownException(throwable);
            }
            if (throwable instanceof CertPathValidatorException) {
                Object object;
                String string = "OCSP response error: ";
                String string2 = throwable.getMessage();
                if (string2 != null && string2.startsWith(string)) {
                    object = string2.substring(string.length());
                    Trace.securityPrintln((String)object);
                    if (((String)object).equals("UNAUTHORIZED") || ((String)object).equals("TRY_LATER") || ((String)object).equals("INTERNAL_ERROR")) {
                        throw new StatusUnknownException(throwable);
                    }
                }
                if ((object = throwable.getCause()) != null && object instanceof IOException) {
                    throw new StatusUnknownException((Throwable)object);
                }
                throw new CertificateException(throwable);
            }
            throw new CertificateException(throwable);
        }
    }

    private OCSP.RevocationStatus doPrivilegedOCSPCheck(final X509Certificate x509Certificate, final URI uRI, final X509Certificate x509Certificate2) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<OCSP.RevocationStatus>(){

            @Override
            public OCSP.RevocationStatus run() throws CertPathValidatorException, IOException {
                try {
                    return OCSP.check((X509Certificate)x509Certificate, (X509Certificate)RevocationChecker.this.issuerCert, (URI)uRI, (X509Certificate)x509Certificate2, (Date)RevocationChecker.this.date, Collections.emptyList(), (String)RevocationChecker.this.variant);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return OCSP.check((X509Certificate)x509Certificate, (X509Certificate)RevocationChecker.this.issuerCert, (URI)uRI, (X509Certificate)x509Certificate2, (Date)RevocationChecker.this.date);
                }
            }
        });
    }

    private void checkCRLs(X509Certificate x509Certificate, boolean bl) throws CertificateException {
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        x509CRLSelector.setCertificateChecking(x509Certificate);
        try {
            CertPathHelper.setDateAndTime(x509CRLSelector, this.date, this.maxClockSkew);
        }
        catch (IllegalAccessError illegalAccessError) {
            RevocationChecker.setDateAndTime(x509CRLSelector, this.date, this.maxClockSkew);
        }
        boolean[] blArray = new boolean[9];
        Set<TrustAnchor> set = Collections.singleton(new TrustAnchor(this.anchor, null));
        Collection<Object> collection = null;
        if (this.configCrl != null) {
            collection = new HashSet<X509CRL>();
            collection.add(this.configCrl);
        } else {
            try {
                collection = this.getCRLsPrivileged(x509CRLSelector, blArray, set);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof CertStoreException) {
                    for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
                        if (!(throwable2 instanceof IOException)) continue;
                        throw new StatusUnknownException(throwable);
                    }
                    throw new CertificateException(throwable);
                }
                throw new CertificateException(throwable);
            }
            catch (IllegalAccessError illegalAccessError) {
                collection = RevocationChecker.getCRLs(x509CRLSelector, this.certCanSignCRL, this.issuerCert.getPublicKey(), this.sigProvider, Collections.emptyList(), blArray, set, this.date);
            }
        }
        if (!collection.isEmpty() && Arrays.equals(blArray, ALL_REASONS)) {
            this.checkApprovedCRLs(x509Certificate, collection);
            if (bl) {
                throw new StatusUnknownException();
            }
        } else {
            throw new StatusUnknownException();
        }
    }

    private Collection<X509CRL> getCRLsPrivileged(final X509CRLSelector x509CRLSelector, final boolean[] blArray, final Set<TrustAnchor> set) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Collection<X509CRL>>(){

            @Override
            public Collection<X509CRL> run() throws CertStoreException {
                try {
                    return DistributionPointFetcher.getCRLs((X509CRLSelector)x509CRLSelector, (boolean)RevocationChecker.this.certCanSignCRL, (PublicKey)RevocationChecker.this.issuerCert.getPublicKey(), null, (String)RevocationChecker.this.sigProvider, Collections.emptyList(), (boolean[])blArray, (Set)set, (Date)RevocationChecker.this.date, (String)RevocationChecker.this.variant);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return DistributionPointFetcher.getCRLs((X509CRLSelector)x509CRLSelector, (boolean)RevocationChecker.this.certCanSignCRL, (PublicKey)RevocationChecker.this.issuerCert.getPublicKey(), (String)RevocationChecker.this.sigProvider, Collections.emptyList(), (boolean[])blArray, (Set)set, (Date)RevocationChecker.this.date);
                }
            }
        });
    }

    private static void setDateAndTime(final X509CRLSelector x509CRLSelector, final Date date, final long l) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Class<?> clazz = Class.forName("sun.security.provider.certpath.CertPathHelper");
                    Method method = clazz.getDeclaredMethod("setDateAndTime", PARAMS);
                    method.setAccessible(true);
                    method.invoke(null, x509CRLSelector, date, l);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException);
            x509CRLSelector.setDateAndTime(date);
        }
    }

    private static Collection<X509CRL> getCRLs(final X509CRLSelector x509CRLSelector, final boolean bl, final PublicKey publicKey, final String string, final List<CertStore> list, final boolean[] blArray, final Set<TrustAnchor> set, final Date date) throws StatusUnknownException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Collection<X509CRL>>(){

                @Override
                public Collection<X509CRL> run() throws Exception {
                    Class<?> clazz = Class.forName("sun.security.provider.certpath.DistributionPointFetcher");
                    Method method = clazz.getDeclaredMethod("getInstance", null);
                    method.setAccessible(true);
                    Object object = method.invoke(null, new Object[0]);
                    method = clazz.getDeclaredMethod("getCRLs", TYPES);
                    method.setAccessible(true);
                    return (Collection)method.invoke(object, x509CRLSelector, bl, publicKey, string, list, blArray, set, date);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException);
            throw new StatusUnknownException();
        }
    }

    private void checkApprovedCRLs(X509Certificate x509Certificate, Collection<X509CRL> collection) throws CertificateException {
        X509CRLEntryImpl x509CRLEntryImpl = null;
        for (X509CRL x509CRL : collection) {
            CRLReason cRLReason;
            X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate(x509Certificate);
            if (x509CRLEntry == null) continue;
            try {
                x509CRLEntryImpl = X509CRLEntryImpl.toImpl(x509CRLEntry);
            }
            catch (CRLException cRLException) {
                throw new CertificateException(cRLException);
            }
            Set<String> set = x509CRLEntryImpl.getCriticalExtensionOIDs();
            if (set != null && !set.isEmpty()) {
                set.remove("2.5.29.21");
                set.remove("2.5.29.29");
                if (!set.isEmpty()) {
                    throw new CertificateException("unresolved critical extensions in CRLEntry");
                }
            }
            if ((cRLReason = x509CRLEntryImpl.getRevocationReason()) == null) {
                cRLReason = CRLReason.UNSPECIFIED;
            }
            Date date = x509CRLEntryImpl.getRevocationDate();
            throw new CertificateRevokedException(date, cRLReason, x509CRL.getIssuerX500Principal(), x509CRLEntryImpl.getExtensions());
        }
    }

    static {
        Permissions permissions = new Permissions();
        PropertyPermission propertyPermission = new PropertyPermission("*", "read,write");
        ((PermissionCollection)permissions).add(propertyPermission);
        ACC_PROP_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};
        PARAMS = new Class[]{X509CRLSelector.class, Date.class, Long.TYPE};
        TYPES = new Class[]{X509CRLSelector.class, Boolean.TYPE, PublicKey.class, String.class, List.class, boolean[].class, Set.class, Date.class};
    }

    static class StatusUnknownException
    extends CertificateException {
        static final long serialVersionUID = -1133298886602198899L;

        StatusUnknownException() {
        }

        StatusUnknownException(String string) {
            super(string);
        }

        StatusUnknownException(Throwable throwable) {
            super(throwable);
        }
    }
}

