/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.MozillaJSSDSASignature;
import com.sun.deploy.security.MozillaJSSNONEwithRSASignature;
import com.sun.deploy.security.MozillaMyKeyStore;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecurityPermission;

public final class MozillaJSSProvider
extends Provider {
    private static final long serialVersionUID = 3884593006617837243L;
    private static final String info = "SunDeploy-MozillaJSS Provider (implements RSA)";
    private static final AccessControlContext ACC_INSTANCE;

    public MozillaJSSProvider() {
        super("SunDeploy-MozillaJSS", 1.5, info);
        final MozillaJSSProvider mozillaJSSProvider = this;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                MozillaJSSProvider.this.putService(new ProviderService(mozillaJSSProvider, "Signature", "NONEwithRSA", "com.sun.deploy.security.MozillaJSSNONEwithRSASignature"));
                MozillaJSSProvider.this.putService(new ProviderService(mozillaJSSProvider, "Signature", "DSA", "com.sun.deploy.security.MozillaJSSDSASignature$SHA1withDSA"));
                MozillaJSSProvider.this.putService(new ProviderService(mozillaJSSProvider, "Signature", "RawDSA", "com.sun.deploy.security.MozillaJSSDSASignature$NONEwithDSA"));
                MozillaJSSProvider.this.putService(new ProviderService(mozillaJSSProvider, "KeyStore", "MozillaMy", "com.sun.deploy.security.MozillaMyKeyStore"));
                return null;
            }
        }, ACC_INSTANCE);
    }

    static {
        Permissions permissions = new Permissions();
        SecurityPermission securityPermission = new SecurityPermission("putProviderProperty.SunDeploy-MozillaJSS");
        ((PermissionCollection)permissions).add(securityPermission);
        ACC_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    private static final class ProviderService
    extends Provider.Service {
        ProviderService(Provider provider, String string, String string2, String string3) {
            super(provider, string, string2, string3, null, null);
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            String string = this.getType();
            if (object != null) {
                throw new InvalidParameterException("constructorParameter not used with " + string + " engines");
            }
            String string2 = this.getAlgorithm();
            try {
                if (string2.equals("NONEwithRSA")) {
                    return new MozillaJSSNONEwithRSASignature();
                }
                if (string2.equals("DSA")) {
                    return new MozillaJSSDSASignature.SHA1withDSA();
                }
                if (string2.equals("RawDSA")) {
                    return new MozillaJSSDSASignature.NONEwithDSA();
                }
                if (string2.equals("MozillaMy")) {
                    return new MozillaMyKeyStore();
                }
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("Error constructing " + string + " for " + string2 + " using SunDeploy-MozillaJSS", exception);
            }
            throw new ProviderException("No impl for " + string2 + " " + string);
        }
    }
}

