/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.MozillaJSSDSAPrivateKey;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public abstract class MozillaJSSDSASignature
extends SignatureSpi {
    private MozillaJSSDSAPrivateKey privateKey = null;

    protected abstract void update(byte[] var1, int var2, int var3);

    protected abstract byte[] getDigest() throws SignatureException;

    protected abstract void resetDigest();

    private Object getJSSSignature(Object object) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName("org.mozilla.jss.crypto.CryptoToken", true, ClassLoader.getSystemClassLoader());
        Class<?> clazz2 = Class.forName("org.mozilla.jss.crypto.SignatureAlgorithm", true, ClassLoader.getSystemClassLoader());
        Class[] classArray = new Class[]{clazz2};
        Method method = clazz.getMethod("getSignatureContext", classArray);
        Field field = clazz2.getField("DSASignature");
        Object[] objectArray = new Object[]{field.get(null)};
        return method.invoke(object, objectArray);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new InvalidKeyException("Key not supported");
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof MozillaJSSDSAPrivateKey)) {
            throw new InvalidKeyException("Key not supported");
        }
        this.privateKey = (MozillaJSSDSAPrivateKey)privateKey;
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        byte[] byArray = new byte[]{by};
        this.update(byArray, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.update(byArray, n, n2);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = this.getDigest();
            Object object = this.privateKey.getJSSPrivateKey();
            Class<?> clazz = Class.forName("org.mozilla.jss.crypto.PrivateKey", true, ClassLoader.getSystemClassLoader());
            Method method = clazz.getMethod("getOwningToken", new Class[0]);
            Object object2 = method.invoke(object, (Object[])null);
            Object object3 = this.getJSSSignature(object2);
            Class<?> clazz2 = Class.forName("org.mozilla.jss.crypto.Signature", true, ClassLoader.getSystemClassLoader());
            Class[] classArray = new Class[]{clazz};
            Method method2 = clazz2.getMethod("initSign", classArray);
            Object[] objectArray = new Object[]{object};
            Object object4 = method2.invoke(object3, objectArray);
            Class[] classArray2 = new Class[]{byte[].class};
            Method method3 = clazz2.getMethod("update", classArray2);
            Object[] objectArray2 = new Object[]{byArray};
            Object object5 = method3.invoke(object3, objectArray2);
            Method method4 = clazz2.getMethod("sign", new Class[0]);
            byte[] byArray2 = (byte[])method4.invoke(object3, (Object[])null);
            byte[] byArray3 = new byte[20];
            byte[] byArray4 = new byte[20];
            System.arraycopy(byArray2, 0, byArray3, 0, 20);
            System.arraycopy(byArray2, 20, byArray4, 0, 20);
            BigInteger bigInteger = new BigInteger(byArray3);
            BigInteger bigInteger2 = new BigInteger(byArray4);
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray5 = derValue.toByteArray();
            return byArray5;
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (Throwable throwable) {
            SignatureException signatureException = new SignatureException("Error generating signature.");
            signatureException.initCause(throwable);
            throw signatureException;
        }
        finally {
            this.resetDigest();
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        throw new SignatureException("Signature verification not supported");
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    public static class NONEwithDSA
    extends MozillaJSSDSASignature {
        private static final int SHA1_LEN = 20;
        private final byte[] digestBuffer = new byte[20];
        private int offset;

        @Override
        protected void update(byte[] byArray, int n, int n2) {
            if (n2 == 0 || byArray == null) {
                return;
            }
            if (this.offset + n2 > 20) {
                this.offset = 21;
                return;
            }
            System.arraycopy(byArray, n, this.digestBuffer, this.offset, n2);
            this.offset += n2;
        }

        @Override
        protected byte[] getDigest() throws SignatureException {
            if (this.offset != 20) {
                throw new SignatureException("Data for RawDSA must be exactly 20 bytes long");
            }
            this.offset = 0;
            return this.digestBuffer;
        }

        @Override
        protected void resetDigest() {
            this.offset = 0;
        }
    }

    public static class SHA1withDSA
    extends MozillaJSSDSASignature {
        private final MessageDigest dataSHA = MessageDigest.getInstance("SHA-1");

        public SHA1withDSA() throws NoSuchAlgorithmException {
            this.dataSHA.reset();
        }

        @Override
        protected void update(byte[] byArray, int n, int n2) {
            if (n2 == 0 || byArray == null) {
                return;
            }
            this.dataSHA.update(byArray, n, n2);
        }

        @Override
        protected byte[] getDigest() {
            return this.dataSHA.digest();
        }

        @Override
        protected void resetDigest() {
            this.dataSHA.reset();
        }
    }
}

