/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.DeployJavaUtilJarAccess;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.TrustedLibraries;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class EnhancedJarVerifier
extends JarVerifier {
    public static JarVerifier create(URL uRL, String string, File file, File file2) {
        if (ResourceProvider.get().hasEnhancedJarAccess()) {
            return new EnhancedJarVerifier(uRL, string, file, file2);
        }
        return null;
    }

    EnhancedJarVerifier(URL uRL, String string, File file, File file2) {
        super(uRL, string, file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(DownloadDelegate downloadDelegate) throws IOException, JARSigningException {
        JarFile jarFile = JarUtil.createJarFile(this.jarFile, true);
        this.manifest = jarFile.getManifest();
        try {
            Object object;
            Object object2;
            Enumeration<Object> enumeration = null;
            int n = 0;
            int n2 = jarFile.size();
            CodeSource[] codeSourceArray = null;
            if (downloadDelegate != null) {
                downloadDelegate.validating(this.jarLocation, 0, n2);
            }
            DeployJavaUtilJarAccess deployJavaUtilJarAccess = DeployJavaUtilJarAccess.instance();
            codeSourceArray = deployJavaUtilJarAccess.getCodeSources(jarFile, this.jarLocation);
            if (BlackList.getInstance().checkJarFile(jarFile)) {
                throw new JARSigningException(this.jarLocation, this.jarVersion, 5);
            }
            if (TrustedLibraries.checkJarFile(jarFile)) {
                object2 = this.manifest.getMainAttributes();
                ((Attributes)object2).putValue("Trusted-Library", Boolean.TRUE.toString());
            }
            if (codeSourceArray != null && codeSourceArray.length > 0) {
                object2 = new ArrayList();
                for (CodeSource codeSource : codeSourceArray) {
                    if (codeSource.getCertificates() == null) continue;
                    this.hasOnlyUnsignedEntries = false;
                    object2.add(codeSource);
                }
                if (object2.size() != codeSourceArray.length) {
                    codeSourceArray = object2.toArray(new CodeSource[object2.size()]);
                } else {
                    this.hasOnlySignedEntries = true;
                }
            }
            enumeration = codeSourceArray != null && codeSourceArray.length > 0 ? deployJavaUtilJarAccess.entryNames(jarFile, codeSourceArray) : jarFile.entries();
            if (codeSourceArray != null && codeSourceArray.length == 1) {
                object2 = codeSourceArray[0].getCertificates();
                this.singleSignerIndicesCert = new int[((Certificate[])object2).length];
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    this.signerCerts.add(object2[i]);
                    this.singleSignerIndicesCert[i] = i;
                }
                this.codeSourceCertCache.put(this.singleSignerIndicesCert, codeSourceArray[0]);
                object = codeSourceArray[0].getCodeSigners();
                this.singleSignerIndicesCS = new int[((Object)object).length];
                for (int i = 0; i < ((Object)object).length; ++i) {
                    this.signersCS.add(object[i]);
                    this.singleSignerIndicesCS[i] = i;
                }
                this.codeSourceCache.put(this.singleSignerIndicesCS, codeSourceArray[0]);
                this.hasSingleCodeSource = true;
            }
            while (enumeration.hasMoreElements()) {
                ++n;
                if (codeSourceArray != null && codeSourceArray.length > 0) {
                    object2 = (String)enumeration.nextElement();
                    object = jarFile.getJarEntry((String)object2);
                } else {
                    object = (JarEntry)enumeration.nextElement();
                    object2 = ((ZipEntry)object).getName();
                }
                if (object2 != null && object != null && JarUtil.canSkipEntry((ZipEntry)object)) continue;
                if (object == null) {
                    this.hasMissingSignedEntries = true;
                    Trace.println("signed entry \"" + (String)object2 + "\" missing from jar " + this.jarLocation, TraceLevel.CACHE);
                }
                this.authenticateJarEntry(jarFile, (JarEntry)object);
                this.processCertificates(jarFile, (JarEntry)object, (String)object2);
                this.processSigners(jarFile, (JarEntry)object, (String)object2);
                if (downloadDelegate == null || n % 10 != 0 && n < n2) continue;
                downloadDelegate.validating(this.jarLocation, n, n2);
            }
            if (downloadDelegate != null) {
                downloadDelegate.validating(this.jarLocation, n2, n2);
            }
        }
        finally {
            jarFile.close();
            this.warnIfUnsigned();
        }
    }
}

