/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;

public class BrowserKeystore {
    private static Object cryptoManager = null;
    private static boolean initializeJSS = false;

    public static void registerSecurityProviders() {
        Provider provider;
        Class<?> clazz;
        Service service = ServiceManager.getService();
        if (service.isIExplorer()) {
            try {
                clazz = Class.forName("com.sun.deploy.security.MSCryptoProvider", true, ClassLoader.getSystemClassLoader());
                if (clazz != null) {
                    provider = (Provider)clazz.newInstance();
                    Security.insertProviderAt(provider, Security.getProviders().length + 1);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (service.isNetscape()) {
            if (BrowserKeystore.isJSSCryptoConfigured()) {
                Trace.msgSecurityPrintln("browserkeystore.jss.config");
                try {
                    clazz = Class.forName("com.sun.deploy.security.MozillaJSSProvider", true, ClassLoader.getSystemClassLoader());
                    if (clazz != null) {
                        provider = (Provider)clazz.newInstance();
                        Security.insertProviderAt(provider, Security.getProviders().length + 1);
                    }
                }
                catch (Throwable throwable) {
                    Trace.msgSecurityPrintln("browserkeystore.jss.notconfig");
                }
            } else {
                Trace.msgSecurityPrintln("browserkeystore.jss.notconfig");
            }
        }
    }

    static synchronized Object getJSSCryptoManager() {
        if (cryptoManager == null && !initializeJSS) {
            initializeJSS = true;
            String string = null;
            string = Platform.get().isBrowserFireFox() ? Platform.get().getFireFoxUserProfileDirectory() : Platform.get().getMozillaUserProfileDirectory();
            Trace.msgSecurityPrintln("browserkeystore.mozilla.dir", new Object[]{string});
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName("org.mozilla.jss.CryptoManager$InitializationValues", true, ClassLoader.getSystemClassLoader());
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    Object obj = constructor.newInstance(string);
                    Field field = clazz.getField("installJSSProvider");
                    field.setBoolean(obj, false);
                    Class<?> clazz2 = Class.forName("org.mozilla.jss.CryptoManager", true, ClassLoader.getSystemClassLoader());
                    Method method = clazz2.getMethod("initialize", clazz);
                    Object object = method.invoke(null, obj);
                    Method method2 = clazz2.getMethod("getInstance", new Class[0]);
                    Object object2 = method2.invoke(null, (Object[])null);
                    Class<?> clazz3 = Class.forName("org.mozilla.jss.util.PasswordCallback", true, ClassLoader.getSystemClassLoader());
                    Method method3 = clazz2.getMethod("setPasswordCallback", clazz3);
                    JSSPasswordCallbackInvocationHandler jSSPasswordCallbackInvocationHandler = new JSSPasswordCallbackInvocationHandler();
                    Class<?> clazz4 = Proxy.getProxyClass(ClassLoader.getSystemClassLoader(), clazz3);
                    Object obj2 = clazz4.getConstructor(InvocationHandler.class).newInstance(jSSPasswordCallbackInvocationHandler);
                    method3.invoke(object2, obj2);
                    cryptoManager = object2;
                    Trace.msgSecurityPrintln("browserkeystore.jss.yes");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Trace.msgSecurityPrintln("browserkeystore.jss.no");
                    return null;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Trace.msgSecurityPrintln("browserkeystore.jss.no");
                    return null;
                }
            }
        }
        return cryptoManager;
    }

    public static boolean isJSSCryptoConfigured() {
        return BrowserKeystore.getJSSCryptoManager() != null;
    }

    private static class JSSPasswordCallbackInvocationHandler
    implements InvocationHandler {
        private HashMap<String, Integer> passwordAttempts = new HashMap();

        private JSSPasswordCallbackInvocationHandler() {
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Object object2;
            if (objectArray != null && objectArray[0] != null) {
                object2 = objectArray[0];
                Class<?> clazz = object2.getClass();
                Method method2 = clazz.getMethod("getName", new Class[0]);
                String string = (String)method2.invoke(object2, (Object[])null);
                String string2 = method.getName();
                Integer n = this.passwordAttempts.get(string);
                if (n == null || n < 2) {
                    if (n == null) {
                        this.passwordAttempts.put(string, 1);
                    } else {
                        this.passwordAttempts.put(string, n + 1);
                    }
                    char[] cArray = this.getPasswordDialog(string);
                    Class<?> clazz2 = Class.forName("org.mozilla.jss.util.Password", true, ClassLoader.getSystemClassLoader());
                    Class[] classArray = new Class[]{char[].class};
                    Constructor<?> constructor = clazz2.getConstructor(classArray);
                    if (cArray != null) {
                        Object[] objectArray2 = new Object[]{cArray};
                        return constructor.newInstance(objectArray2);
                    }
                }
            }
            object2 = Class.forName("org.mozilla.jss.util.PasswordCallback$GiveUpException", true, ClassLoader.getSystemClassLoader());
            throw (Throwable)((Class)object2).newInstance();
        }

        private char[] getPasswordDialog(String string) {
            String string2 = ResourceManager.getString("browserkeystore.password.dialog.text", string);
            CredentialInfo credentialInfo = ToolkitStore.getUI().showPasswordDialog(null, ResourceManager.getString("password.dialog.title"), string2, false, false, null, false, null);
            if (credentialInfo == null) {
                return null;
            }
            return credentialInfo.getPassword();
        }
    }
}

