/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.trace.Trace;
import java.net.URL;
import java.util.StringTokenizer;

public abstract class AbstractBrowserProxyHandler
implements ProxyHandler {
    @Override
    public final boolean isSupported(int n) {
        return n == 3;
    }

    @Override
    public final boolean isProxyCacheSupported() {
        return false;
    }

    @Override
    public final void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        Trace.msgNetPrintln("net.proxy.loading.browser");
        if (!this.isSupported(browserProxyInfo.getType())) {
            throw new ProxyConfigException("Unable to support proxy type: " + browserProxyInfo.getType());
        }
        Trace.msgNetPrintln("net.proxy.loading.done");
    }

    @Override
    public final ProxyInfo[] getProxyInfo(URL uRL) {
        String string = this.findProxyForURL(uRL.toString());
        return this.extractAutoProxySetting(string);
    }

    protected abstract String findProxyForURL(String var1);

    private ProxyInfo[] extractAutoProxySetting(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
            ProxyInfo[] proxyInfoArray = new ProxyInfo[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = string2.indexOf("PROXY");
                if (n2 != -1) {
                    proxyInfoArray[n++] = new ProxyInfo(string2.substring(n2 + 6));
                    continue;
                }
                n2 = string2.indexOf("SOCKS");
                if (n2 != -1) {
                    proxyInfoArray[n++] = new ProxyInfo(null, string2.substring(n2 + 6));
                    continue;
                }
                proxyInfoArray[n++] = new ProxyInfo(null, -1);
            }
            return proxyInfoArray;
        }
        return new ProxyInfo[]{new ProxyInfo(null)};
    }
}

