/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.protocol.jar;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.URLEncoder;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.net.www.protocol.jar.Handler;
import sun.net.www.protocol.jar.JarURLConnection;

public class DeployURLConnection
extends JarURLConnection {
    private URL _jarFileURL = null;
    private String _entryName;
    private JarEntry _jarEntry;
    private JarFile _jarFile;
    private String _contentType;
    private boolean _useCachedJar = false;
    private Map<String, List<String>> _headerFields = null;
    private URL _jarFileURLOverride = null;
    private boolean _ignoreClassPath;
    private boolean _useVersionProtocol;
    private static final AccessControlContext ACC_FILE_INSTANCE;

    DeployURLConnection(URL uRL, Handler handler, boolean bl, boolean bl2) throws MalformedURLException, IOException {
        super(DeployURLConnection.getAnchoredURL(uRL), handler);
        this._ignoreClassPath = bl;
        this._useVersionProtocol = bl2;
        this.getJarFileURL();
        this._entryName = this.getEntryName();
    }

    private static URL getAnchoredURL(URL uRL) {
        if (!Config.isJavaVersionAtLeast10() && Config.isJavaVersionAtLeast9()) {
            try {
                return new URL(uRL.toString() + "#runtime");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uRL;
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this._jarEntry;
    }

    @Override
    public synchronized URL getJarFileURL() {
        URL uRL;
        if (this._jarFile instanceof ResourceObject && (uRL = ((ResourceObject)((Object)this._jarFile)).getResourceURL()) != null) {
            return uRL;
        }
        if (this._jarFileURL == null) {
            this._jarFileURL = super.getJarFileURL();
        }
        if (this._useVersionProtocol) {
            if (this._jarFileURLOverride != null) {
                return this._jarFileURLOverride;
            }
            try {
                this._jarFileURL = new URL(URLUtil.canonicalize(this._jarFileURL.toString()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this._jarFileURL;
    }

    @Override
    public JarFile getJarFile() throws IOException {
        if (this._useVersionProtocol) {
            this._jarFile = this.getJarFileWithVersionId();
        } else {
            this.connect();
        }
        if (ResourceProvider.get().isInternalUse()) {
            return this._jarFile;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                @Override
                public JarFile run() throws Exception {
                    if (DeployURLConnection.this._jarFile instanceof ResourceObject) {
                        return (JarFile)((ResourceObject)((Object)DeployURLConnection.this._jarFile)).clone();
                    }
                    String string = DeployURLConnection.this._jarFile.getName();
                    if (new File(string).exists()) {
                        Manifest manifest;
                        JarFile jarFile = JarUtil.createJarFile(new File(string), true);
                        if (DeployURLConnection.this._ignoreClassPath && (manifest = jarFile.getManifest()) != null) {
                            manifest.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
                        }
                        return jarFile;
                    }
                    return DeployURLConnection.this._jarFile;
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getCause().getMessage());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (!this._useCachedJar) {
            return super.getInputStream();
        }
        if (this._entryName == null) {
            throw new IOException("no entry name specified");
        }
        if (this._jarEntry == null) {
            throw new FileNotFoundException("JAR entry " + this._entryName + " not found in " + this._jarFile.getName());
        }
        return this._jarFile.getInputStream(this._jarEntry);
    }

    @Override
    public Object getContent() throws IOException {
        this.connect();
        if (this._useCachedJar && this._entryName == null) {
            return this.getJarFile();
        }
        return super.getContent();
    }

    @Override
    public String getContentType() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._useCachedJar) {
            if (this._contentType == null) {
                if (this._entryName == null) {
                    this._contentType = "x-java/jar";
                } else {
                    try {
                        this.connect();
                        JarFile jarFile = this._useVersionProtocol ? this.getJarFileWithVersionId() : this._jarFile;
                        InputStream inputStream = jarFile.getInputStream(this._jarEntry);
                        this._contentType = DeployURLConnection.guessContentTypeFromStream(new BufferedInputStream(inputStream));
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this._contentType == null) {
                    this._contentType = DeployURLConnection.guessContentTypeFromName(this._entryName);
                }
                if (this._contentType == null) {
                    this._contentType = "content/unknown";
                }
            }
        } else {
            this._contentType = super.getContentType();
        }
        return this._contentType;
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            return super.getContentLength();
        }
        if (this._useCachedJar) {
            if (this._jarEntry != null) {
                return (int)this._jarEntry.getSize();
            }
            return -1;
        }
        return super.getContentLength();
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            URL uRL = new URL(this._jarFileURL.getProtocol(), this._jarFileURL.getHost(), this._jarFileURL.getPort(), this._jarFileURL.getPath());
            String string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL.toString());
            URL uRL2 = string == null ? this._jarFileURL : uRL;
            boolean bl = false;
            if ("file".equalsIgnoreCase(uRL2.getProtocol()) && !this.isLocalJREJar(uRL2)) {
                ResourceProvider.get().getResource(uRL2, string, true, 256, null);
                bl = true;
            }
            if (ResourceProvider.get().canCache(uRL)) {
                block14: {
                    Resource resource;
                    int n;
                    this.setUseCaches(false);
                    Integer n2 = (Integer)ToolkitStore.get().getAppContext().get("deploy-download-type-" + uRL.toString());
                    int n3 = n = n2 == null ? 0 : n2;
                    if ((n & 0x100000) != 0 && (resource = ResourceProvider.get().getCachedResource(uRL2, string)) == null) {
                        ResourceProvider.get().getResource(uRL2, string, true, n, null);
                    }
                    if (!bl) {
                        if ((n & 0x1000) != 0) {
                            this.retrieveJarFromCache(string, uRL2);
                        } else {
                            try {
                                super.connect();
                                this.retrieveJarFromCache(string, uRL2);
                            }
                            catch (IOException iOException) {
                                this.retrieveJarFromCache(string, uRL2);
                                if (this._jarFile != null) break block14;
                                throw iOException;
                            }
                        }
                    }
                }
                if (this._jarFile != null) {
                    this._useCachedJar = true;
                } else {
                    super.connect();
                    this._jarFile = super.getJarFile();
                }
            } else {
                super.connect();
                this._jarFile = super.getJarFile();
            }
            if (this._entryName != null) {
                this._jarEntry = this._jarFile.getJarEntry(this._entryName);
                if (this._jarEntry == null) {
                    throw new FileNotFoundException("JAR entry " + this._entryName + " not found in " + this._jarFile.getName());
                }
            }
            this.connected = true;
        }
    }

    private void retrieveJarFromCache(String string, URL uRL) throws IOException {
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        this._jarFile = resource != null ? resource.getJarFile() : null;
        this._headerFields = resource != null ? resource.getHeaders() : null;
    }

    @Override
    public URL getURL() {
        URL uRL;
        if (this._jarFile instanceof ResourceObject && (uRL = ((ResourceObject)((Object)this._jarFile)).getResourceURL()) != null) {
            try {
                return URLUtil.getJarEntryURL(uRL, this._entryName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return super.getURL();
    }

    @Override
    public String getHeaderField(String string) {
        if (string == null) {
            return null;
        }
        try {
            this.connect();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        if (this._headerFields != null) {
            List<String> list = this._headerFields.get(string.toLowerCase());
            if (list != null && list.size() > 0) {
                return list.get(0);
            }
            return null;
        }
        return super.getHeaderField(string);
    }

    @Override
    public Permission getPermission() throws IOException {
        String string;
        if (Config.isJavaVersionAtLeast18() && ((string = this.url.toString().toLowerCase()).startsWith("jar:http:") || string.startsWith("jar:https:"))) {
            String string2;
            int n = (string2 = this.url.toString()).indexOf("!/");
            string2 = string2.substring(4, n > -1 ? n : string2.length());
            URL uRL = new URL(string2);
            return URLUtil.getURLConnectPermission(uRL);
        }
        return super.getPermission();
    }

    private synchronized JarFile getJarFileWithVersionId() throws IOException {
        String string;
        if (this._jarFile != null) {
            return this._jarFile;
        }
        if (ResourceProvider.get().canCache(this._jarFileURL) && (string = (String)ToolkitStore.get().getAppContext().get("deploy-" + this._jarFileURL.toString())) != null) {
            this._jarFileURLOverride = new URL(URLUtil.canonicalize(this._jarFileURL.toString() + "?" + URLEncoder.encode("version-id", "UTF-8") + "=" + URLEncoder.encode(string, "UTF-8")));
            String string2 = ResourceProvider.get().getCurrentVersion(this._jarFileURL);
            if (string2 != null && !string2.equals(string)) {
                this._jarFileURLOverride = new URL(this._jarFileURLOverride.toString() + "&" + URLEncoder.encode("current-version-id", "UTF-8") + "=" + URLEncoder.encode(string2, "UTF-8"));
            }
        }
        this.connect();
        this._jarFileURLOverride = null;
        return this._jarFile;
    }

    private boolean isLocalJREJar(URL uRL) throws IOException {
        final String string = Platform.get().getLongPathName(Config.getJREHome());
        String string2 = null;
        try {
            string2 = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return new File(string).toURI().toURL().getPath();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getCause().getMessage());
        }
        return uRL.getPath().startsWith(string2);
    }

    static {
        Permissions permissions = new Permissions();
        ((PermissionCollection)permissions).add(new FilePermission("<<ALL FILES>>", "read,write"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessDeclaredMembers"));
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }
}

