/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.proxy.NSPreferences;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SearchPath;
import com.sun.deploy.util.SystemPropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class UnixPlatform
extends Platform {
    private String _userHome;
    private String _systemHome;
    private String _osHome;
    private static final int[] DEFAULT_SIZES = new int[]{32, 16, 48, 64};
    private UnixWebJavaSwitch javaSwitch = new UnixWebJavaSwitch();
    private static final int ARGS_LIST_CAPACITY = 32;
    private static final int ARG_CAPACITY = 64;
    private static final char BACKSLASH = '\\';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char TAB = '\t';
    private static final char LINEFEED = '\n';
    private static final char RETURN = '\r';
    private static final char SPACE = ' ';

    public UnixPlatform() {
        this.loadDeployNativeLib();
    }

    @Override
    public void loadDeployNativeLib() {
        try {
            System.load(Environment.getDeploymentHome() + File.separator + this.getNativeLibPath());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    @Override
    public String getNativeLibPath() {
        return "lib" + File.separator + "libdeploy.so";
    }

    public String escapeBackslashAndQuoteString(String string) {
        return string;
    }

    @Override
    public String getUserHome() {
        if (this._userHome == null) {
            String string = SystemPropertyUtil.getProperty("javaplugin.user.profile");
            if (string == null || string.trim().equals("")) {
                string = SystemPropertyUtil.getProperty("user.home");
            }
            this._userHome = string + (string.endsWith(File.separator) ? "" : File.separator) + ".java" + File.separator + "deployment";
        }
        return this._userHome;
    }

    @Override
    public String getSystemHome() {
        if (this._systemHome == null) {
            this._systemHome = File.separator + "etc" + File.separator + ".java" + File.separator + "deployment";
        }
        return this._systemHome;
    }

    @Override
    public String getOSHome() {
        if (this._osHome == null) {
            this._osHome = File.separator + "etc";
        }
        return this._osHome;
    }

    @Override
    public boolean isBrowserFireFox() {
        return false;
    }

    @Override
    public boolean isNativeModalDialogUp() {
        return false;
    }

    @Override
    public String getRoamingUserHome() {
        return null;
    }

    @Override
    public String getPlatformExtension() {
        return "";
    }

    @Override
    public String getLibraryPrefix() {
        return "lib";
    }

    @Override
    public String getLibrarySufix() {
        return ".so";
    }

    @Override
    public int installShortcut(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return 0;
    }

    @Override
    public int updateShortcut(String string, String string2) {
        return 0;
    }

    @Override
    public String getShortcutJnlpName(String string) {
        Properties properties = new Properties();
        File file = new File(string);
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string2 = (String)properties.get("Exec");
            if (string2 == null) {
                return null;
            }
            int n = string2.lastIndexOf(47);
            if (n != -1 && string2.length() - ++n > 0) {
                String string3 = string2.substring(n);
                return string3;
            }
        }
        return null;
    }

    @Override
    public boolean useAltFileSystemView() {
        return false;
    }

    @Override
    public boolean isLocalInstallSupported() {
        return this.getEnv("GNOME_DESKTOP_SESSION_ID") != null || new File("/usr/share/gnome").exists() || this.getEnv("DBUS_SESSION_BUS_ADDRESS") != null || this.getEnv("_DBUS_SESSION_BUS_ADDRESS") != null;
    }

    @Override
    public boolean systemLookAndFeelDefault() {
        return this.getEnv("GNOME_DESKTOP_SESSION_ID") != null || new File("/usr/share/gnome").exists() || this.getEnv("DBUS_SESSION_BUS_ADDRESS") != null || this.getEnv("_DBUS_SESSION_BUS_ADDRESS") != null;
    }

    @Override
    public String getSessionSpecificString() {
        String string = this.getEnv("DISPLAY");
        if (string != null) {
            return string;
        }
        return "";
    }

    @Override
    public String getPlatformSpecificJavaName() {
        return "java";
    }

    public native String getEnv(String var1);

    @Override
    public String getBrowserPath() {
        File file;
        String string = Config.getStringProperty("deployment.browser.path");
        if (string != null && string.length() > 0 && !(file = new File(string)).exists()) {
            string = null;
        }
        if ((string == null || string.length() == 0) && (file = SearchPath.findBrowser(this.getEnv("PATH"))) != null) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    @Override
    public String getFireFoxUserProfileDirectory() {
        return this.getMozillaUserProfileDirectory();
    }

    @Override
    public String getMozillaUserProfileDirectory() {
        String string = null;
        try {
            String string2 = System.getProperty("user.home");
            File file = new File(string2 + "/.mozilla/appreg");
            if (file.exists()) {
                string = NSPreferences.getNS6UserProfileDirectory(file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private String getJControlCommand() {
        String string = Environment.getJavaHome();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + "bin" + File.separator + "jcontrol";
        return string;
    }

    @Override
    public void openControlPanel(String[] stringArray) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = this.getJControlCommand();
            arrayList.add(string);
            for (String string2 : stringArray) {
                arrayList.add(string2);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            Process process = processBuilder.start();
            Trace.println("launching jcontrol", TraceLevel.BASIC);
            process.waitFor();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        catch (InterruptedException interruptedException) {
            Trace.ignoredException(interruptedException);
        }
    }

    private File findOpenUtility(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getEnv("XDG_CURRENT_DESKTOP");
        if (string2 != null) {
            if (string2.toLowerCase().contains("gnome")) {
                arrayList.add("gnome-open");
            } else if (string2.toLowerCase().contains("kde")) {
                arrayList.add("kde-open");
            }
        }
        arrayList.add("xdg-open");
        return SearchPath.findOne(string, arrayList);
    }

    private boolean executeProcess(String[] stringArray) {
        boolean bl = false;
        if (stringArray == null) {
            return false;
        }
        try {
            Trace.println("Invoking process with: \n     " + this.argsFromArray(stringArray), TraceLevel.BASIC);
            Process process = Runtime.getRuntime().exec(stringArray);
            bl = process != null;
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        return bl;
    }

    public String argsFromArray(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(2048);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append(' ');
        }
        return stringBuffer.toString().trim();
    }

    public String[] argsFromString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(32);
        StringBuffer stringBuffer = new StringBuffer(64);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        String[] stringArray = new String[]{};
        if (string != null) {
            n = string.length();
        }
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if (++i >= n) continue block6;
                    stringBuffer.append(string.charAt(i));
                    continue block6;
                }
                case '\'': {
                    if (bl) {
                        stringBuffer.append(c);
                    }
                    bl2 = !bl2;
                    continue block6;
                }
                case '\"': {
                    if (bl2) {
                        stringBuffer.append(c);
                    }
                    bl = !bl;
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl2 || bl) {
                        stringBuffer.append(c);
                        continue block6;
                    }
                    if (stringBuffer.length() <= 0) continue block6;
                    arrayList.add(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList.toArray(stringArray);
    }

    private String[] getBasicBrowserArgs(File file, String string) {
        String[] stringArray = new String[]{file.getAbsolutePath(), string};
        return stringArray;
    }

    private String[] getExtendedBrowserArgs(File file, String string) {
        boolean bl = false;
        String[] stringArray = this.argsFromString(Config.getStringProperty("deployment.browser.args"));
        String[] stringArray2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            int n = 0;
            int n2 = -1;
            n2 = stringArray[i].indexOf("%u", n);
            while (n2 >= 0) {
                stringArray[i] = stringArray[i].substring(n, n2) + string + stringArray[i].substring(n2 + 2);
                n = n2 + 2;
                n2 = stringArray[i].indexOf("%u", n);
                bl = true;
            }
        }
        if (bl) {
            stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            stringArray2[0] = file.getAbsolutePath();
        }
        return stringArray2;
    }

    @Override
    public String getDebugJavaPath(String string) {
        return string;
    }

    @Override
    public boolean isPlatformIconType(String string) {
        return this.isLocalInstallSupported() && (string.toLowerCase().endsWith(".png") || string.toLowerCase().endsWith(".ico"));
    }

    @Override
    public List<JREInfo> getInstalledJREList() {
        return this.getPublicJres();
    }

    @Override
    public String getBrowserHomePath() {
        return Environment.getenv("MOZILLA_HOME");
    }

    @Override
    public String getUserHomeOverride() {
        return null;
    }

    @Override
    public void setUserHomeOverride(String string) {
    }

    public void init() {
    }

    @Override
    public void onSave(Object object) {
    }

    @Override
    public void onLoad(Object object) {
    }

    @Override
    public void resetJavaHome() {
    }

    @Override
    public String getSecureLauncherName() {
        return "jweblauncher";
    }

    @Override
    void setDefaultConfigProperties(DefaultConfig defaultConfig) {
        defaultConfig.setProperty("deployment.browser.path", "");
        defaultConfig.setProperty("deployment.browser.args", "-remote openURL(%u,new-window)");
    }

    public List<JREInfo> getPublicJres() {
        String string = System.getProperty("java.version");
        int n = string.lastIndexOf("-");
        ArrayList<JREInfo> arrayList = new ArrayList<JREInfo>();
        if (n != -1) {
            string = string.substring(0, n);
        }
        JREInfo jREInfo = new JREInfo(null, string, null, Environment.getJavaHome(), "", Config.getOSName(), Config.getOSArch(), true, true);
        arrayList.add(jREInfo);
        return arrayList;
    }

    @Override
    public String getLongPathName(String string) {
        return string;
    }

    @Override
    public boolean samePaths(String string, String string2) {
        try {
            return new File(string).getCanonicalPath().equals(new File(string2).getCanonicalPath());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public boolean canBecomeAdmin() {
        return this.hasAdminPrivileges();
    }

    @Override
    public boolean hasAdminPrivileges() {
        return false;
    }

    @Override
    public void handleUserResponse(int n) {
    }

    @Override
    public boolean shouldPromptForAutoCheck() {
        return false;
    }

    @Override
    public String toExecArg(String string) {
        return string;
    }

    public boolean showURL(String string) {
        return false;
    }

    @Override
    public int[] getIconSizes() {
        return (int[])DEFAULT_SIZES.clone();
    }

    @Override
    public int getSystemShortcutIconSize(boolean bl) {
        return bl ? 32 : 16;
    }

    @Override
    public String getSystemJavawsPath() {
        return Environment.getJavawsCommand();
    }

    @Override
    public long getNativePID() {
        return this.getPlatformPID();
    }

    @Override
    public String getDefaultSystemCache() {
        return null;
    }

    @Override
    public boolean canAutoDownloadJRE() {
        return true;
    }

    @Override
    public void addRemoveProgramsAdd(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
    }

    @Override
    public void addRemoveProgramsRemove(String string, boolean bl) {
    }

    @Override
    public void cacheSecurityBaseline(String string, String string2) {
    }

    @Override
    public void cacheCurrentConfig(Properties properties) {
        try {
            File file = new File(System.getProperty("user.home"));
            File file2 = new File(file, ".java/deployment");
            File file3 = new File(file2, "config.cache");
            file2.mkdirs();
            file3.delete();
            PrintStream printStream = new PrintStream(file3, "UTF-8");
            printStream.println("#This file is autogenerated. Do not edit it manually.");
            printStream.println("#To update Java deployment configuration use jcontrol utility");
            printStream.println("# or update deployment.properties.");
            for (String string : properties.keySet()) {
                printStream.println(string + "=" + properties.getProperty(string));
            }
            printStream.close();
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    @Override
    public Platform.WebJavaSwitch getWebJavaSwitch() {
        return this.javaSwitch;
    }

    @Override
    public native int getPlatformMaxCommandLineLength();

    protected native long getPlatformPID();

    @Override
    public String getLoadedNativeLibPath(String string) {
        throw new UnsupportedOperationException("Not yet supported on Unix platform.");
    }

    @Override
    public native boolean isGTKAvailable(int var1, int var2, int var3);

    public static final class UnixWebJavaSwitch
    extends Platform.WebJavaSwitch {
        private UnixWebJavaSwitch() {
        }

        @Override
        protected boolean isSystemWebJavaEnabled() {
            return true;
        }

        @Override
        protected void setSystemWebJavaEnabled(boolean bl) {
        }
    }
}

