/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.ImmutableAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

final class ImmutableManifest
extends Manifest {
    private final Manifest backingStore;
    private final Attributes readOnlyAttributes;
    private final Map<String, Attributes> readOnlyEntries;

    public ImmutableManifest() {
        this(new Manifest());
    }

    public ImmutableManifest(InputStream inputStream) throws IOException {
        this(new Manifest(inputStream));
    }

    public ImmutableManifest(Manifest manifest) {
        this.backingStore = new Manifest(manifest);
        this.readOnlyAttributes = new ImmutableAttributes(this.backingStore.getMainAttributes());
        Map<String, Attributes> map = this.backingStore.getEntries();
        LinkedHashMap<String, ImmutableAttributes> linkedHashMap = new LinkedHashMap<String, ImmutableAttributes>();
        for (String string : map.keySet()) {
            linkedHashMap.put(string, new ImmutableAttributes(map.get(string)));
        }
        this.readOnlyEntries = Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public Attributes getMainAttributes() {
        return this.readOnlyAttributes;
    }

    @Override
    public Map<String, Attributes> getEntries() {
        return this.readOnlyEntries;
    }

    @Override
    public Attributes getAttributes(String string) {
        return this.readOnlyEntries.get(string);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Manifest) {
            Manifest manifest = (Manifest)object;
            return this.readOnlyAttributes.equals(manifest.getMainAttributes()) && this.readOnlyEntries.equals(manifest.getEntries());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.readOnlyAttributes.hashCode() + this.readOnlyEntries.hashCode();
    }

    @Override
    public Object clone() {
        return new ImmutableManifest(this);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.backingStore.write(outputStream);
    }

    @Override
    public void read(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }
}

