/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.association.Action;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppAssociationWriter;
import com.sun.deploy.association.utility.AppUtility;
import com.sun.deploy.association.utility.GnomeAssociationUtil;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.trace.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

final class GnomeAppAssociationWriter
implements AppAssociationWriter {
    static final String GNOMEDIR_VALUE = GnomeAssociationUtil.getEnv("GNOMEDIR");
    static final String GNOME_LINUX_SYSTEM_SHARE_DIR = GNOMEDIR_VALUE == null ? "/usr/share/" : GNOMEDIR_VALUE + "/share/";
    static final String GNOME_SOLARIS_SYSTEM_SHARE_DIR = "/usr/share/gnome/";
    static final String GNOME_LINUX_SYSTEM_MIME_INFO_DIR = GNOME_LINUX_SYSTEM_SHARE_DIR + "mime-info/";
    static final String GNOME_SOLARIS_SYSTEM_MIME_INFO_DIR = "/usr/share/gnome/mime-info/";
    static final String GNOME_LINUX_SYSTEM_APPLICATION_REGISTRY_DIR = GNOME_LINUX_SYSTEM_SHARE_DIR + "application-registry/";
    static final String GNOME_SOLARIS_SYSTEM_APPLICATION_REGISTRY_DIR = "/usr/share/gnome/application-registry/";
    static final String OSNAME = System.getProperty("os.name").toLowerCase();
    static final String GNOME_SYSTEM_MIME_INFO_DIR = OSNAME.equals("linux") ? GNOME_LINUX_SYSTEM_MIME_INFO_DIR : "/usr/share/gnome/mime-info/";
    static final String GNOME_SYSTEM_APPLICATION_REGISTRY_DIR = OSNAME.equals("linux") ? GNOME_LINUX_SYSTEM_APPLICATION_REGISTRY_DIR : "/usr/share/gnome/application-registry/";
    static final String GNOME_USER_MIME_INFO_DIR = System.getProperty("user.home") + "/.gnome/mime-info/";
    static final String GNOME_USER_APPLICATION_INFO_DIR = System.getProperty("user.home") + "/.gnome/application-info/";
    static final String MIME_SUFFIX = ".mime";
    static final String KEYS_SUFFIX = ".keys";
    static final String APPLICATIONS_SUFFIX = ".applications";
    private String defaultAppID = null;
    private String defaultAppCommand = null;

    public GnomeAppAssociationWriter(LocalApplicationProperties localApplicationProperties) {
    }

    private String fileExtListToString(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2 == null) continue;
                string2 = AppUtility.removeDotFromFileExtension(string2);
                if (string.length() == 0) {
                    string = string.concat(string2);
                    continue;
                }
                string = string.concat(' ' + string2);
            }
        } else {
            string = null;
        }
        return string;
    }

    private String getSystemDotMimeFilePath(Association association) {
        return GNOME_SYSTEM_MIME_INFO_DIR + association.getName() + MIME_SUFFIX;
    }

    private String getSystemDotKeysFilePath(Association association) {
        return GNOME_SYSTEM_MIME_INFO_DIR + association.getName() + KEYS_SUFFIX;
    }

    private String getSystemDotApplicationsFilePath(Association association) {
        return GNOME_SYSTEM_APPLICATION_REGISTRY_DIR + association.getName() + APPLICATIONS_SUFFIX;
    }

    private String getUserDotMimeFilePath(Association association) {
        return GNOME_USER_MIME_INFO_DIR + association.getName() + MIME_SUFFIX;
    }

    private String getUserDotKeysFilePath(Association association) {
        return GNOME_USER_MIME_INFO_DIR + association.getName() + KEYS_SUFFIX;
    }

    private String getUserDotApplicationsFilePath(Association association) {
        return GNOME_USER_APPLICATION_INFO_DIR + association.getName() + APPLICATIONS_SUFFIX;
    }

    private void checkSystemMIMEDatabase() throws IOException {
        File file = null;
        file = new File(GNOME_SYSTEM_MIME_INFO_DIR);
        if (!file.exists()) {
            throw new IOException("The system MIME info directory doesn't exist: " + GNOME_SYSTEM_MIME_INFO_DIR + ". Make sure Gnome 2.0+ is installed and env GNOMEDIR is set properly.");
        }
        file = new File(GNOME_SYSTEM_APPLICATION_REGISTRY_DIR);
        if (!file.exists()) {
            throw new IOException("The system MIME info directory doesn't exist: " + GNOME_SYSTEM_APPLICATION_REGISTRY_DIR + ". Make sure Gnome 2.0+ is installed and env GNOMEDIR is set properly.");
        }
        file = new File(GNOME_SYSTEM_MIME_INFO_DIR);
        if (!file.canWrite()) {
            throw new IOException("No write permission to the system MIME info directory: " + GNOME_SYSTEM_MIME_INFO_DIR);
        }
        file = new File(GNOME_SYSTEM_APPLICATION_REGISTRY_DIR);
        if (!file.canWrite()) {
            throw new IOException("No write permission to the system MIME info directory: " + GNOME_SYSTEM_APPLICATION_REGISTRY_DIR);
        }
    }

    private void checkUserMIMEDatabase() throws IOException {
        boolean bl;
        File file = null;
        file = new File(GNOME_USER_MIME_INFO_DIR);
        if (!file.exists() && !(bl = file.mkdirs())) {
            throw new IOException("The user MIME info directory doesn't exist, and fails to be created: " + GNOME_USER_MIME_INFO_DIR);
        }
        file = new File(GNOME_USER_APPLICATION_INFO_DIR);
        if (!file.exists() && !(bl = file.mkdirs())) {
            throw new IOException("The user MIME info directory doesn't exist, and fails to be created: " + GNOME_USER_APPLICATION_INFO_DIR);
        }
        file = new File(GNOME_USER_MIME_INFO_DIR);
        if (!file.canWrite()) {
            throw new IOException("No write permission to the user MIME info directory: " + GNOME_USER_MIME_INFO_DIR);
        }
        file = new File(GNOME_USER_APPLICATION_INFO_DIR);
        if (!file.canWrite()) {
            throw new IOException("No write permission to the user MIME info directory: " + GNOME_USER_MIME_INFO_DIR);
        }
    }

    private void createFile(String string) throws IOException {
        boolean bl = false;
        File file = new File(string);
        if (!file.exists() && !(bl = file.createNewFile())) {
            throw new IOException("Create MIME file: " + string + " failed.");
        }
    }

    private void parseOpenAction(Association association) {
        List<Action> list = association.getActionList();
        if (list == null) {
            return;
        }
        String string = null;
        Iterator<Action> iterator = list.iterator();
        while (iterator.hasNext() && this.defaultAppCommand == null) {
            Action action = iterator.next();
            string = action.getVerb();
            if (!string.equalsIgnoreCase("open")) continue;
            this.defaultAppCommand = action.getCommand().trim();
        }
        if (this.defaultAppCommand != null) {
            int n = this.defaultAppCommand.lastIndexOf(File.separator);
            this.defaultAppID = n == -1 || n == this.defaultAppCommand.length() - 1 ? this.defaultAppCommand : this.defaultAppCommand.substring(n + 1, this.defaultAppCommand.length());
        }
    }

    private void writeDotMimeFile(Association association, String string) throws IOException {
        this.createFile(string);
        String string2 = association.getMimeType();
        List<String> list = association.getFileExtList();
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string, true));
            bufferedWriter.write(string2 + "\n");
            String string3 = null;
            string3 = list == null ? "" : this.fileExtListToString(list);
            bufferedWriter.write("\text: " + string3 + "\n");
            bufferedWriter.write("\n");
        }
        catch (IOException iOException) {
            throw new IOException("Write mime info to " + string + " failed.");
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeDotKeysFile(Association association, String string) throws IOException {
        this.createFile(string);
        String string2 = association.getMimeType();
        String string3 = association.getDescription();
        String string4 = association.getIconFileName();
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string, true));
            bufferedWriter.write(string2 + "\n");
            if (string3 != null) {
                bufferedWriter.write("\tdescription=" + string3 + "\n");
            }
            if (string4 != null) {
                bufferedWriter.write("\ticon_filename=" + string4 + "\n");
            }
            this.parseOpenAction(association);
            if (this.defaultAppID != null) {
                bufferedWriter.write("\tdefault_action_type=application\n");
                bufferedWriter.write("\tdefault_application_id=" + this.defaultAppID + "\n");
                bufferedWriter.write("\tshort_list_application_user_additions=" + this.defaultAppID + "\n");
            }
            bufferedWriter.write("\n");
        }
        catch (IOException iOException) {
            throw new IOException("Write mime info to " + string + " failed.");
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeDotApplicationsFile(Association association, String string) throws IOException {
        this.createFile(string);
        BufferedWriter bufferedWriter = null;
        try {
            this.parseOpenAction(association);
            if (this.defaultAppID != null && this.defaultAppCommand != null) {
                bufferedWriter = new BufferedWriter(new FileWriter(string, true));
                bufferedWriter.write(this.defaultAppID + "\n");
                bufferedWriter.write("\tcommand=" + this.defaultAppCommand + "\n");
                bufferedWriter.write("\tname=" + this.defaultAppID + "\n");
                bufferedWriter.write("\tcan_open_multiple_files=false\n");
                bufferedWriter.write("\trequires_terminal=false\n");
                String string2 = association.getMimeType();
                bufferedWriter.write("\tmime_types=" + string2 + "\n");
                bufferedWriter.write("\n");
            }
        }
        catch (IOException iOException) {
            throw new IOException("Write mime info to " + string + " failed.");
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean dotMimeFileContains(File file, String string, String string2) {
        boolean bl = false;
        boolean bl2 = string2 == null;
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string.equals(string3)) {
                    bl = true;
                    if (!bl2) continue;
                    break;
                }
                if (bl2 || !string3.contains("ext:") || !string3.contains(string2)) continue;
                bl2 = true;
                if (!bl) continue;
            }
            bufferedReader.close();
            return bl && bl2;
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
            return false;
        }
    }

    @Override
    public void checkAssociationValidForRegistration(Association association) throws IllegalArgumentException {
        if (association.getName() == null || association.getMimeType() == null) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the name and mimeType fields to perform this operation.");
        }
    }

    @Override
    public void checkAssociationValidForUnregistration(Association association) throws IllegalArgumentException {
        if (association.getName() == null) {
            throw new IllegalArgumentException("The given association is invalid. It should specify the name field to perform this operation.");
        }
    }

    @Override
    public boolean isAssociationExist(Association association, int n) {
        File file = null;
        file = n == 2 ? new File(this.getSystemDotMimeFilePath(association)) : new File(this.getUserDotMimeFilePath(association));
        List<String> list = association.getFileExtList();
        String string = null;
        if (list != null) {
            string = this.fileExtListToString(list);
        }
        if (file.exists()) {
            if (association.getMimeType() == null) {
                return true;
            }
            return this.dotMimeFileContains(file, association.getMimeType(), string);
        }
        return false;
    }

    @Override
    public void registerAssociation(Association association, int n) throws RegisterFailedException {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            if (n == 2) {
                this.checkSystemMIMEDatabase();
                string = this.getSystemDotMimeFilePath(association);
                string2 = this.getSystemDotKeysFilePath(association);
                string3 = this.getSystemDotApplicationsFilePath(association);
            } else {
                this.checkUserMIMEDatabase();
                string = this.getUserDotMimeFilePath(association);
                string2 = this.getUserDotKeysFilePath(association);
                string3 = this.getUserDotApplicationsFilePath(association);
            }
            this.writeDotMimeFile(association, string);
            this.writeDotKeysFile(association, string2);
            this.writeDotApplicationsFile(association, string3);
        }
        catch (IOException iOException) {
            if (string != null) {
                new File(string).delete();
            }
            if (string2 != null) {
                new File(string2).delete();
            }
            if (string3 != null) {
                new File(string3).delete();
            }
            throw new RegisterFailedException(iOException.getMessage());
        }
    }

    @Override
    public void unregisterAssociation(Association association, int n) throws RegisterFailedException {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            if (n == 2) {
                this.checkSystemMIMEDatabase();
                string = this.getSystemDotMimeFilePath(association);
                string2 = this.getSystemDotKeysFilePath(association);
                string3 = this.getSystemDotApplicationsFilePath(association);
            } else {
                this.checkUserMIMEDatabase();
                string = this.getUserDotMimeFilePath(association);
                string2 = this.getUserDotKeysFilePath(association);
                string3 = this.getUserDotApplicationsFilePath(association);
            }
            new File(string).delete();
            new File(string2).delete();
            new File(string3).delete();
        }
        catch (IOException iOException) {
            throw new RegisterFailedException(iOException.getMessage());
        }
    }
}

