/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui.wizards;

import com.oracle.jmc.common.unit.IConstrainedMap;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.flightrecorder.controlpanel.ui.FlightRecorderProvider;
import com.oracle.jmc.flightrecorder.controlpanel.ui.jobs.StartRecordingJob;
import com.oracle.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizard;
import com.oracle.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.oracle.jmc.ui.misc.DialogToolkit;
import org.eclipse.swt.widgets.Display;

public class StartRecordingWizard
extends RecordingWizard {
    private final FlightRecorderProvider recorder;

    public StartRecordingWizard(RecordingWizardModel model, FlightRecorderProvider recorder) {
        super(model);
        this.recorder = recorder;
    }

    @Override
    public boolean performFinish() {
        boolean superFinish = super.performFinish();
        if (!superFinish) {
            return false;
        }
        this.startRecording(this.getModel());
        return true;
    }

    private void startRecording(RecordingWizardModel wizardModel) {
        try {
            IConstrainedMap<String> recordingOptions = wizardModel.buildOptions();
            StartRecordingJob sr = new StartRecordingJob(this.recorder, wizardModel.getName(), recordingOptions, wizardModel.getAndSaveEventSettings(), wizardModel.getPath());
            sr.schedule();
        }
        catch (QuantityConversionException | IllegalArgumentException e) {
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.FLIGHT_RECORDING_OPTIONS_PROBLEM_TITLE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

