/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui.wizards;

import com.oracle.jmc.flightrecorder.configuration.events.IEventConfiguration;
import com.oracle.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import com.oracle.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.controlpanel.ui.model.EventConfiguration;
import com.oracle.jmc.flightrecorder.controlpanel.ui.wizards.RecordingTemplateControlView;
import com.oracle.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public final class RecordingEventOptionsWizardPage
extends WizardPage
implements Observer {
    public static final String PAGE_NAME = "recordingEventOptionsWizard";
    private static final int WIZARD_STAGE = 1;
    private final RecordingWizardModel m_model;
    private RecordingTemplateControlView m_controlView;

    public RecordingEventOptionsWizardPage(RecordingWizardModel model) {
        super(PAGE_NAME);
        this.m_model = model;
        this.setImageDescriptor(ControlPanel.getDefault().getMCImageDescriptor("startjfrwiz.gif"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setDescription(Messages.START_RECORDING_EVENT_OPTIONS_WIZARD_PAGE_DESCRIPTION);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        this.m_controlView = new RecordingTemplateControlView(container, this::setError);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.oracle.jmc.flightrecorder.controlpanel.ui.recording_wizard");
    }

    private void setError(String errorMessage) {
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.oracle.jmc.flightrecorder.controlpanel.ui.recording_wizard");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IEventConfiguration ourConfig = this.m_model.getCurrentConfigurationAt(1);
            this.setTitle(NLS.bind((String)Messages.START_RECORDING_EVENT_OPTIONS_WIZARD_PAGE_TITLE, (Object)this.m_model.getCurrentConfigurationAt(1).getName()));
            XMLModel ourModel = ((EventConfiguration)ourConfig).getXMLModel();
            IEventConfiguration activeConfig = this.m_model.getActiveConfiguration();
            if (activeConfig != ourConfig) {
                if (!activeConfig.equalSettings(ourConfig)) {
                    this.setMessage(Messages.START_RECORDING_WIZARD_LATER_STAGE_CHANGE_WARNING, 2);
                } else {
                    this.setMessage(null);
                }
                ourModel.setDirty(false);
                ourModel.addObserver((Observer)this);
            } else {
                this.setMessage(null);
            }
            this.m_controlView.cleanCreate(ourModel);
        }
        super.setVisible(visible);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof XMLModel) {
            this.m_model.flushConfigurationsBeyond(1);
            this.setMessage(null);
            o.deleteObserver(this);
        }
    }
}

