/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui.wizards;

import com.oracle.jmc.common.unit.IConstrainedMap;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.oracle.jmc.flightrecorder.controlpanel.ui.jobs.UpdateRecordingJob;
import com.oracle.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizard;
import com.oracle.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.oracle.jmc.ui.misc.DialogToolkit;
import org.eclipse.swt.widgets.Display;

public class EditRecordingWizard
extends RecordingWizard {
    private final RecordingProvider recording;

    public EditRecordingWizard(RecordingProvider recording, RecordingWizardModel model) {
        super(model);
        this.recording = recording;
    }

    @Override
    public boolean performFinish() {
        boolean superFinish = super.performFinish();
        if (!superFinish) {
            return false;
        }
        this.editRecording(this.getModel());
        return true;
    }

    private void editRecording(RecordingWizardModel wizardModel) {
        try {
            IConstrainedMap<String> recordingOptions = wizardModel.buildOptions();
            this.recording.setDumpToFile(wizardModel.getPath());
            UpdateRecordingJob updateJob = new UpdateRecordingJob(this.recording.getServerHandle(), this.recording.getRecordingDescriptor(), recordingOptions, wizardModel.getAndSaveEventSettings());
            updateJob.schedule();
        }
        catch (QuantityConversionException | IllegalArgumentException e) {
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.FLIGHT_RECORDING_OPTIONS_PROBLEM_TITLE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

