/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui.wizards;

import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.core.MCFile;
import com.oracle.jmc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.oracle.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.oracle.jmc.rjmx.ConnectionException;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.subscription.IMBeanHelperService;
import java.io.Closeable;
import org.eclipse.osgi.util.NLS;

public class DumpRecordingWizardModel {
    private final IConnectionHandle m_connection;
    private final RecordingProvider m_recordingProvider;
    private MCFile m_path;
    private IQuantity m_recordingStartTime;

    public DumpRecordingWizardModel(RecordingProvider recording) throws ConnectionException {
        this.m_recordingProvider = recording;
        this.m_path = recording.getDumpToFile();
        this.m_recordingStartTime = recording.getRecordingDescriptor().getStartTime();
        if (this.m_recordingStartTime == null) {
            this.m_recordingStartTime = this.currentServerTime();
        }
        this.m_connection = recording.getServerHandle().connect(NLS.bind((String)Messages.DUMP_RECORDING_CONNECTION, (Object)recording.getName()));
    }

    public IQuantity recordingEndTime() {
        IQuantity endTime = this.m_recordingProvider.getEndTime();
        if (endTime != null && this.recordingIsStopped()) {
            return endTime;
        }
        return this.currentServerTime();
    }

    private boolean recordingIsStopped() {
        return this.m_recordingProvider != null && this.m_recordingProvider.isStopped();
    }

    private IQuantity currentServerTime() {
        IMBeanHelperService service = (IMBeanHelperService)this.m_connection.getServiceOrDummy(IMBeanHelperService.class);
        return UnitLookup.EPOCHMILLIS.quantity(service.getApproximateServerTime(System.currentTimeMillis()));
    }

    public RecordingProvider getRecordingProvider() {
        return this.m_recordingProvider;
    }

    public MCFile getPath() {
        return this.m_path;
    }

    public IQuantity getRecordingStartTime() {
        return this.m_recordingStartTime;
    }

    public void setPath(MCFile path) {
        this.m_path = path;
    }

    public void dispose() {
        IOToolkit.closeSilently((Closeable)this.m_connection);
    }
}

