/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui.recordingconfiguration;

import com.oracle.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.PathElement;
import com.oracle.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.Property;
import com.oracle.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyContainer;
import com.oracle.jmc.flightrecorder.ui.common.TypeLabelProvider;
import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.misc.AdaptingLabelProvider;
import com.oracle.jmc.ui.misc.SWTColorToolkit;
import java.awt.Color;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

final class PropertyLabelProvider
extends AdaptingLabelProvider {
    PropertyLabelProvider() {
    }

    public Image getImage(Object element) {
        if (element instanceof PropertyContainer.FolderNode) {
            return UIPlugin.getDefault().getImage("fldr_obj.gif");
        }
        if (element instanceof PropertyContainer.EventNode) {
            return PropertyLabelProvider.getEventImage((PropertyContainer.EventNode)element);
        }
        assert (element instanceof Property);
        return UIPlugin.getDefault().getImage("property_obj.gif");
    }

    private static Image getEventImage(PropertyContainer.EventNode container) {
        String key = container.getEventTypeID().getFullKey();
        return SWTColorToolkit.getColorThumbnail((RGB)SWTColorToolkit.asRGB((Color)TypeLabelProvider.getColorOrDefault((String)key)));
    }

    public String getText(Object element) {
        if (element instanceof PathElement) {
            String text = ((PathElement)element).getName();
            if (element instanceof Property) {
                Property property = (Property)element;
                String value = property.getValue();
                if ("period".equals(text) && "everyChunk".equals(value)) {
                    value = Messages.RECORDING_TEMPLATE_ONCE_PER_CHUNK;
                }
                text = String.valueOf(text) + '=' + value;
            }
            return text;
        }
        assert (false);
        return super.getText(element);
    }

    public Font getFont(Object element) {
        if (element instanceof PathElement) {
            return this.getFont((PathElement)element);
        }
        return null;
    }

    private Font getFont(PathElement pathElement) {
        switch (pathElement.getKind()) {
            case IN_CONFIGURATION: {
                return this.getPropertyDoesNotExistFont();
            }
            case IN_BOTH: {
                return this.getPropertyPartOfTemplateFont();
            }
            case IN_SERVER: {
                return this.getNormalFont();
            }
        }
        throw new IllegalArgumentException("Illegal type " + (Object)((Object)pathElement.getKind()) + '!');
    }

    private Font getPropertyDoesNotExistFont() {
        FontDescriptor fd = JFaceResources.getFontRegistry().defaultFontDescriptor().setStyle(3);
        return (Font)JFaceResources.getResources().get((DeviceResourceDescriptor)fd);
    }

    private Font getPropertyPartOfTemplateFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    private Font getNormalFont() {
        return JFaceResources.getDefaultFont();
    }

    public org.eclipse.swt.graphics.Color getForeground(Object element) {
        if (element instanceof PathElement && ((PathElement)element).getKind() == PathElement.PathElementKind.IN_CONFIGURATION) {
            return JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
        }
        return null;
    }

    public org.eclipse.swt.graphics.Color getBackground(Object element) {
        return null;
    }
}

