/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui.jobs;

import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.common.unit.IConstrainedMap;
import com.oracle.jmc.core.StatusFactory;
import com.oracle.jmc.flightrecorder.configuration.events.EventOptionID;
import com.oracle.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.IServerHandle;
import com.oracle.jmc.rjmx.services.jfr.IFlightRecorderService;
import com.oracle.jmc.rjmx.services.jfr.IRecordingDescriptor;
import java.io.Closeable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class UpdateRecordingJob
extends Job {
    private final IRecordingDescriptor m_recordingDescriptor;
    private final IConstrainedMap<String> m_recordingOptions;
    private final IConstrainedMap<EventOptionID> m_recordingSettings;
    private final IServerHandle m_server;

    public UpdateRecordingJob(IServerHandle server, IRecordingDescriptor recordingDescriptor, IConstrainedMap<String> recordingOptions, IConstrainedMap<EventOptionID> recordingSettings) {
        super(NLS.bind((String)Messages.UPDATE_RECORDING_JOB_NAME, (Object)recordingDescriptor.getName()));
        this.m_server = server;
        this.m_recordingDescriptor = recordingDescriptor;
        this.m_recordingOptions = recordingOptions;
        this.m_recordingSettings = recordingSettings;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        IConnectionHandle connection = null;
        try {
            connection = this.m_server.connect(this.getName());
            IFlightRecorderService flightRecorderService = (IFlightRecorderService)connection.getServiceOrThrow(IFlightRecorderService.class);
            flightRecorderService.updateRecordingOptions(this.m_recordingDescriptor, this.m_recordingOptions);
            flightRecorderService.updateEventOptions(this.m_recordingDescriptor, this.m_recordingSettings);
            iStatus = StatusFactory.createOk((String)Messages.UPDATE_RECORDING_JOB_SUCCESS_MSG);
        }
        catch (Exception e) {
            IStatus iStatus2;
            try {
                iStatus2 = StatusFactory.createErr((String)NLS.bind((String)Messages.UPDATE_RECORDING_JOB_SERVICE_ERROR_MSG, (Object)this.m_recordingDescriptor.getName()));
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(connection);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)connection);
            return iStatus2;
        }
        IOToolkit.closeSilently((Closeable)connection);
        return iStatus;
    }
}

