/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui.actions;

import com.oracle.jmc.common.IDisplayable;
import com.oracle.jmc.common.internal.IUserAction;
import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.common.unit.IConstrainedMap;
import com.oracle.jmc.flightrecorder.configuration.events.EventOptionID;
import com.oracle.jmc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.oracle.jmc.rjmx.ConnectionException;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.ServiceNotAvailableException;
import com.oracle.jmc.rjmx.services.jfr.FlightRecorderException;
import com.oracle.jmc.rjmx.services.jfr.IEventTypeInfo;
import com.oracle.jmc.rjmx.services.jfr.IFlightRecorderService;
import com.oracle.jmc.rjmx.services.jfr.IRecordingDescriptor;
import com.oracle.jmc.ui.misc.IGraphical;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;

public class PrintRecordingDescriptorAction
implements IUserAction,
IGraphical {
    private final IRecordingDescriptor recording;
    private IFlightRecorderService flightRecorderService;
    private final RecordingProvider rec;

    public PrintRecordingDescriptorAction(RecordingProvider recording) {
        this.rec = recording;
        this.recording = recording.getRecordingDescriptor();
    }

    private PrintStream createNewOutputStream() {
        PrintStream newOut = null;
        try {
            String fileName = System.getProperty("com.oracle.jmc.flightrecorder.controlpanel.ui.printRecordingFileName");
            if (fileName != null) {
                newOut = new PrintStream(new FileOutputStream(fileName));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return newOut;
    }

    private void printRecordingInfo(PrintStream stream) {
        this.printRecordingInfo(new PrintWriter(stream));
    }

    private void printRecordingInfo(PrintWriter writer) {
        try {
            this.printDivider(writer);
            this.printRecordingDescriptor(writer);
            this.printRecordingOptions(writer);
            this.printEventSettings(writer);
            this.printAvailableRecordingOptions(writer);
            this.printAvailableEventTypes(writer);
            this.printCurrentEventTypeSettings(writer);
            this.printDivider(writer);
            writer.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void printDivider(PrintWriter writer) {
        writer.println("============================================================");
    }

    private void printRecordingDescriptor(PrintWriter writer) {
        writer.printf("id=%d%n", this.recording.getId());
        writer.printf("name=%s%n", this.recording.getName());
        writer.printf("state=%s%n", this.recording.getState());
        writer.printf("options=%n", new Object[0]);
        for (Map.Entry entry : this.recording.getOptions().entrySet()) {
            writer.printf("\t%s=%s%s%n", entry.getKey(), entry.getValue(), entry.getValue() != null ? NLS.bind((String)" ({0})", entry.getValue().getClass()) : "");
        }
        writer.printf("objectName=%s%n", this.recording.getObjectName());
        writer.printf("dataStartTime=%s%n", this.display((IDisplayable)this.recording.getDataStartTime()));
        writer.printf("dataEndTime=%s%n", this.display((IDisplayable)this.recording.getDataEndTime()));
    }

    private String display(IDisplayable displayable) {
        return displayable != null ? displayable.displayUsing("auto") : null;
    }

    private void printRecordingOptions(PrintWriter writer) throws FlightRecorderException, IllegalArgumentException, ConnectionException {
        IConstrainedMap options = this.flightRecorderService.getRecordingOptions(this.recording);
        writer.printf("getRecordingOptions(recordingDescriptor)=%n", new Object[0]);
        for (String key : options.valueKeySet()) {
            writer.printf("\t%s=%n\t\t%s, %s%n", key, options.getPersistableString((Object)key), options.getConstraint((Object)key));
        }
    }

    private void printEventSettings(PrintWriter writer) throws FlightRecorderException {
        IConstrainedMap settings = this.flightRecorderService.getEventSettings(this.recording);
        TreeSet options = new TreeSet(settings.valueKeySet());
        writer.printf("getEventSettings(recordingDescriptor)=%n", new Object[0]);
        for (EventOptionID optionID : options) {
            writer.printf("\t%s=%n\t\t%s%n", optionID, settings.getPersistableString((Object)optionID));
        }
    }

    private void printAvailableRecordingOptions(PrintWriter writer) throws FlightRecorderException {
        Map optionDescriptors = this.flightRecorderService.getAvailableRecordingOptions();
        writer.printf("getAvailableRecordingOptions()=%n", new Object[0]);
        for (Map.Entry entry : optionDescriptors.entrySet()) {
            writer.printf("\t%s=\t%s%n", entry.getKey(), entry.getValue());
        }
    }

    private void printAvailableEventTypes(PrintWriter writer) throws FlightRecorderException {
        writer.printf("getAvailableEventTypes()=%n", new Object[0]);
        int i = 0;
        for (IEventTypeInfo eventType : this.flightRecorderService.getAvailableEventTypes()) {
            writer.printf("\t[%d]\t%s%n", i++, this.toString(eventType, "\t\t"));
        }
    }

    private void printCurrentEventTypeSettings(PrintWriter writer) throws FlightRecorderException {
        IConstrainedMap settings = this.flightRecorderService.getCurrentEventTypeSettings();
        TreeSet options = new TreeSet(settings.valueKeySet());
        writer.printf("getCurrentEventTypeSettings()=%n", new Object[0]);
        for (EventOptionID optionID : options) {
            writer.printf("\t%s=%n\t\t%s%n", optionID, settings.getPersistableString((Object)optionID));
        }
    }

    private String toString(IEventTypeInfo eventTypeInfo, String indent) {
        return eventTypeInfo.toString();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return "Print";
    }

    public String getDescription() {
        return null;
    }

    /*
     * Loose catch block
     */
    public void execute() {
        block10: {
            PrintStream oldOut = System.err;
            PrintStream newOut = null;
            IConnectionHandle handle = null;
            try {
                handle = this.rec.getServerHandle().connect("Print Recording Info");
                this.flightRecorderService = (IFlightRecorderService)handle.getServiceOrThrow(IFlightRecorderService.class);
                newOut = this.createNewOutputStream();
                if (newOut != null) {
                    System.setErr(newOut);
                    this.printRecordingInfo(newOut);
                    System.setErr(oldOut);
                } else {
                    this.printRecordingInfo(System.err);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                IOToolkit.closeSilently((Closeable)handle);
                IOToolkit.closeSilently(newOut);
                break block10;
            }
            catch (ConnectionException e) {
                e.printStackTrace();
                IOToolkit.closeSilently((Closeable)handle);
                IOToolkit.closeSilently(newOut);
                break block10;
            }
            catch (ServiceNotAvailableException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        IOToolkit.closeSilently(handle);
                        IOToolkit.closeSilently(newOut);
                        throw throwable;
                    }
                }
                IOToolkit.closeSilently((Closeable)handle);
                IOToolkit.closeSilently(newOut);
                break block10;
            }
            IOToolkit.closeSilently((Closeable)handle);
            IOToolkit.closeSilently((Closeable)newOut);
        }
    }
}

