/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui.actions;

import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import com.oracle.jmc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.oracle.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.controlpanel.ui.wizards.EditRecordingWizard;
import com.oracle.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.services.jfr.IFlightRecorderService;
import com.oracle.jmc.ui.wizards.AbstractWizardUserAction;
import java.io.Closeable;
import org.eclipse.jface.wizard.IWizard;

public class EditRecordingAction
extends AbstractWizardUserAction {
    private final RecordingProvider recording;

    public EditRecordingAction(RecordingProvider recording) {
        super(Messages.ACTION_EDIT_RECORDING_LABEL, Messages.ACTION_EDIT_RECORDING_TOOLTIP, ControlPanel.getDefault().getMCImageDescriptor("jfr_edit.png"));
        this.recording = recording;
    }

    public IWizard doCreateWizard() throws Exception {
        EditRecordingWizard editRecordingWizard;
        IConnectionHandle connection = null;
        try {
            connection = this.recording.getServerHandle().connect(Messages.ACTION_EDIT_RECORDING_LABEL);
            editRecordingWizard = new EditRecordingWizard(this.recording, new RecordingWizardModel((IFlightRecorderService)connection.getServiceOrThrow(IFlightRecorderService.class), this.recording.getRecordingDescriptor(), this.recording.getDumpToFile()));
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(connection);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)connection);
        return editRecordingWizard;
    }
}

