/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui;

import com.oracle.jmc.core.CorePlugin;
import com.oracle.jmc.core.MCFile;
import com.oracle.jmc.core.idesupport.IDESupportToolkit;
import com.oracle.jmc.core.idesupport.IIDESupport;
import com.oracle.jmc.flightrecorder.controlpanel.ui.ImageConstants;
import com.oracle.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.controlpanel.ui.model.ConfigurationRepositoryFactory;
import com.oracle.jmc.flightrecorder.controlpanel.ui.model.EventConfigurationRepository;
import com.oracle.jmc.rjmx.IServerHandle;
import com.oracle.jmc.rjmx.services.jfr.FlightRecorderException;
import com.oracle.jmc.rjmx.services.jfr.IFlightRecorderService;
import com.oracle.jmc.ui.MCAbstractUIPlugin;
import com.oracle.jmc.ui.misc.DialogToolkit;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageRegistry;
import org.osgi.framework.BundleContext;

public final class ControlPanel
extends MCAbstractUIPlugin {
    private static final String LAST_PATH = "last.jfr.path";
    public static final String PLUGIN_ID = "com.oracle.jmc.flightrecorder.controlpanel.ui";
    private static final String LICENSE_URL = "http://www.oracle.com/technetwork/java/javase/terms/products/index.html";
    private static final String DEFAULT_FILENAME = "flight_recording";
    private static final int MAX_FILENAME_SUFFIX_LENGTH = 100;
    private static ControlPanel s_plugin;
    private EventConfigurationRepository m_repository;

    public ControlPanel() {
        super(PLUGIN_ID);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        s_plugin = this;
        this.m_repository = ConfigurationRepositoryFactory.create();
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerFromImageConstantClass(registry, ImageConstants.class);
    }

    public void stop(BundleContext context) throws Exception {
        s_plugin = null;
        super.stop(context);
    }

    public static ControlPanel getDefault() {
        return s_plugin;
    }

    public EventConfigurationRepository getRecordingTemplateRepository() {
        return this.m_repository;
    }

    public static boolean askUserForEnable(IFlightRecorderService flrService, String question) throws FlightRecorderException {
        if (DialogToolkit.openQuestionWithLinkOnUiThread((String)Messages.COMMERCIAL_FEATURES_QUESTION_TITLE, (String)(String.valueOf(question) + "\n\n" + Messages.COMMERCIAL_FEATURES_QUESTION_TIP + "\n\n" + Messages.COMMERCIAL_FEATURES_QUESTION_LICENSE), (String)Messages.COMMERCIAL_FEATURES_QUESTION_LINKTEXT, (String)LICENSE_URL)) {
            flrService.enable();
            return true;
        }
        return false;
    }

    public static MCFile getDefaultRecordingFile(IServerHandle server) {
        return ControlPanel.getDefaultRecordingFile(server.getServerDescriptor().getDisplayName());
    }

    public static MCFile getDefaultRecordingFile(String suffixPart) {
        suffixPart = (suffixPart = suffixPart.replaceAll("[^A-Za-z0-9]", "")).length() > 0 ? "_" + suffixPart : suffixPart;
        suffixPart = suffixPart.length() > 100 ? suffixPart.substring(0, 100) : suffixPart;
        String lastPathStr = ControlPanel.getDefault().getPreferenceStore().getString(LAST_PATH);
        if (lastPathStr.isEmpty()) {
            lastPathStr = String.valueOf(ControlPanel.getDefaultRecordingFolder()) + File.separator + "dummy.jfr";
        }
        IPath lastPath = Path.fromOSString((String)lastPathStr);
        IPath lastFolder = lastPath.removeLastSegments(1);
        MCFile f = ControlPanel.getDefaultRecordingFile(lastFolder, suffixPart);
        int i = 1;
        while (IDESupportToolkit.validateFileResourcePath((String)f.getPath()) == IIDESupport.FILE_EXISTS_STATUS && i < 100000) {
            f = ControlPanel.getDefaultRecordingFile(lastFolder, String.valueOf(suffixPart) + "_" + i++);
        }
        return f;
    }

    private static String getDefaultRecordingFolder() {
        return System.getProperty("user.home");
    }

    private static MCFile getDefaultRecordingFile(IPath folder, String suffixPart) {
        String filename = DEFAULT_FILENAME + suffixPart + "." + "jfr";
        return IDESupportToolkit.createDefaultFileResource((String)folder.append(filename).toOSString());
    }

    public static MCFile openRecordingFileBrowser(MCFile currentFile) {
        MCFile selected = CorePlugin.getDefault().getIDESupport().browseForSaveAsFile(Messages.RECORDING_FILE_BROWSER_TITLE, currentFile.getPath(), "jfr", Messages.RECORDING_FILE_BROWSER_DESCRIPTION);
        if (selected != null) {
            ControlPanel.getDefault().getPreferenceStore().putValue(LAST_PATH, selected.getPath());
        }
        return selected;
    }

    public static String getRecordingFileValidationMessage(IStatus pathValidation) {
        if (pathValidation == IIDESupport.FILE_EXISTS_STATUS) {
            return Messages.RECORDING_FILE_EXISTS;
        }
        if (!pathValidation.isOK()) {
            return pathValidation.getMessage();
        }
        return null;
    }
}

