/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.browser.wizards;

import com.oracle.jmc.browser.JVMBrowserPlugin;
import com.oracle.jmc.browser.wizards.ConnectionWizardModel;
import com.oracle.jmc.browser.wizards.Messages;
import com.oracle.jmc.core.security.CredentialsNotAvailableException;
import com.oracle.jmc.core.security.ICredentials;
import com.oracle.jmc.core.security.SecurityException;
import com.oracle.jmc.rjmx.ConnectionDescriptorBuilder;
import com.oracle.jmc.rjmx.ConnectionToolkit;
import com.oracle.jmc.rjmx.IConnectionDescriptor;
import com.oracle.jmc.rjmx.IServerDescriptor;
import com.oracle.jmc.rjmx.IServerHandle;
import com.oracle.jmc.rjmx.internal.ServerDescriptor;
import com.oracle.jmc.rjmx.internal.ServerToolkit;
import com.oracle.jmc.rjmx.servermodel.IServer;
import com.oracle.jmc.rjmx.servermodel.internal.Server;
import com.oracle.jmc.rjmx.servermodel.internal.ServerModelCredentials;
import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.misc.DialogToolkit;
import com.oracle.jmc.ui.wizards.RelinkableWizardPage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ConnectionWizardPage
extends RelinkableWizardPage {
    private static final int WIDTH_HINT = 400;
    private static final String LOCALHOST = "localhost";
    private static final String PROTOCOL_RMI = "rmi";
    static final String PAGE_NAME = Messages.ConnectionWizardPage_PAGE_NAME;
    private final String serverPath;
    private final Server server;
    private final ConnectionWizardModel model;
    private Text hostNameField;
    private Text usernameField;
    private Text portField;
    private Text javaCommandField;
    private Label javaCommandCaption;
    private Text jvmArgsField;
    private Label jvmArgsCaption;
    private Text passwordField;
    private Text connectionNameField;
    private Button storePasswordButton;
    private final InputVerifier verifier = new InputVerifier();
    private boolean hasEditedConnectionName = false;
    private JMXServiceURL currentUrl;
    private Button customUrlButton;
    private Text testConnectionStatusText;
    private boolean enableTextVerifier = true;
    private StackLayout fieldStackLayout;
    private Composite hostNamePortFieldComposite;
    private Composite serviceUrlComposite;
    private Composite fieldStack;
    private Text serviceUrlField;
    private Label pidCaption;
    private Text pidField;
    private boolean connectionFailed;
    public static final String HOSTNAME_FIELD_NAME = "wizards.connection.text.host";
    public static final String PORT_FIELD_NAME = "wizards.connection.text.port";
    public static final String USERNAME_FIELD_NAME = "wizards.connection.text.user";
    public static final String PASSWORD_FIELD_NAME = "wizards.connection.text.password";
    public static final String CONNECTIONNAME_FIELD_NAME = "wizards.connection.text.name";

    private void showServiceUrlField() {
        this.enableTextVerifier = false;
        this.serviceUrlField.setText(this.currentUrl.toString());
        this.serviceUrlField.setEditable(this.isEditable());
        this.enableTextVerifier = true;
        this.fieldStackLayout.topControl = this.serviceUrlComposite;
        this.fieldStack.layout();
    }

    private void setInputFieldsShowing(boolean showServiceUrlField) {
        if (showServiceUrlField) {
            this.showServiceUrlField();
        } else {
            this.fieldStackLayout.topControl = this.hostNamePortFieldComposite;
            this.fieldStack.layout();
        }
        this.checkIsPageComplete();
    }

    private boolean updateHostAndPortFromServiceURL() {
        try {
            JMXServiceURL tmpUrl = new JMXServiceURL(this.serviceUrlField.getText());
            this.hostNameField.setText(ConnectionToolkit.getHostName((JMXServiceURL)tmpUrl));
            this.portField.setText(String.valueOf(ConnectionToolkit.getPort((JMXServiceURL)tmpUrl)));
            this.setErrorMessage(null);
            return true;
        }
        catch (MalformedURLException e) {
            this.setMessage(null);
            this.setErrorMessage(NLS.bind((String)Messages.ConnectionWizardPage_ERROR_MESSAGE_NOT_VALID_SERVICE_URL, (Object)e.getLocalizedMessage()));
            this.setPageComplete(false);
            return false;
        }
    }

    public ConnectionWizardPage(Server server, String serverPath, ConnectionWizardModel serverConnectModel) {
        super(PAGE_NAME, Messages.ConnectionWizardPage_PAGE_TITLE, null);
        this.server = server;
        this.serverPath = serverPath;
        this.model = serverConnectModel;
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)new GridLayout(2, false));
        if (this.isDiscovered()) {
            this.addCommandLineInfo(c);
            this.addJVMArgsInfo(c);
            this.addPidInfo(c);
        }
        if (!this.isDiscovered() || this.hasServiceUrl()) {
            this.createHostPortServiceURLComposite(c);
        }
        ConnectionWizardPage.createLine(c, 2);
        if (!this.isDiscovered()) {
            this.addUsernameAndPassword(c);
            this.addEncryptionOption(c);
        }
        ConnectionWizardPage.createLine(c, 2);
        this.addConnectionName(c);
        if (this.isEditable()) {
            this.addConnectionTester(c);
        }
        this.setControl((Control)c);
        this.initializeFields();
        if (this.isEditable()) {
            this.hookListeners();
        }
        this.checkIsPageComplete();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.oracle.jmc.browser.create_connector");
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.oracle.jmc.browser.create_connector");
    }

    private void hookListeners() {
        this.hostNameField.addModifyListener((ModifyListener)this.verifier);
        this.connectionNameField.addModifyListener((ModifyListener)this.verifier);
        this.serviceUrlField.addModifyListener((ModifyListener)this.verifier);
        this.portField.addModifyListener((ModifyListener)this.verifier);
        this.usernameField.addModifyListener((ModifyListener)this.verifier);
        this.passwordField.addModifyListener((ModifyListener)this.verifier);
    }

    static void selectAllOnFocus(final Text text) {
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                text.selectAll();
            }
        });
    }

    private void addConnectionTester(Composite c) {
        Label connectionStatusLabel = new Label(c, 16384);
        connectionStatusLabel.setText(Messages.ConnectionWizardPage_STATUS_CAPTION);
        connectionStatusLabel.setToolTipText(Messages.ConnectionWizardPage_STATUS_TOOLTIP);
        Composite testConnectionComposite = new Composite(c, 16384);
        GridData data = new GridData(4, 0x1000000, true, false);
        testConnectionComposite.setLayoutData((Object)data);
        GridLayout l = new GridLayout(2, false);
        l.marginWidth = 0;
        l.marginHeight = 0;
        testConnectionComposite.setLayout((Layout)l);
        this.testConnectionStatusText = new Text(testConnectionComposite, 18440);
        this.testConnectionStatusText.setText(Messages.ConnectionWizardPage_STATUS_IS_UNTESTED);
        data = new GridData(4, 0x1000000, true, false);
        this.testConnectionStatusText.setLayoutData((Object)data);
        Button testConnectionButton = new Button(testConnectionComposite, 0x1000000);
        testConnectionButton.setText(Messages.ConnectionWizardPage_TEST_CONNECTION);
        testConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionWizardPage.this.testConnection() == null) {
                    ConnectionWizardPage.this.testConnectionStatusText.setText(Messages.ConnectionWizardPage_STATUS_IS_CONNECTED);
                } else {
                    ConnectionWizardPage.this.setConnectionFailed();
                    ConnectionWizardPage.this.testConnectionStatusText.setText(Messages.ConnectionWizardPage_STATUS_IS_NOT_CONNECTED);
                }
            }
        });
    }

    private void addConnectionName(Composite parent) {
        Label connectionNameLabel = new Label(parent, 16384);
        connectionNameLabel.setText(Messages.ConnectionWizardPage_CONNECTION_NAME_CAPTION);
        connectionNameLabel.setToolTipText(Messages.ConnectionWizardPage_CONNECTION_NAME_TOOLTIP);
        this.connectionNameField = new Text(parent, 2052);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 400;
        this.connectionNameField.setLayoutData((Object)data);
        this.connectionNameField.setData("name", (Object)CONNECTIONNAME_FIELD_NAME);
        ConnectionWizardPage.selectAllOnFocus(this.connectionNameField);
    }

    private void addEncryptionOption(Composite parent) {
        Label dummy = new Label(parent, 16384);
        dummy.setText("");
        Composite encryptionComposite = new Composite(parent, 0);
        encryptionComposite.setLayout((Layout)new GridLayout(2, false));
        this.storePasswordButton = new Button(encryptionComposite, 32);
        this.storePasswordButton.setText(Messages.ConnectionWizardPage_STORE_CAPTION);
        GridData data = new GridData(4, 0x1000000, true, false);
        this.storePasswordButton.setLayoutData((Object)data);
        new Label(encryptionComposite, 0);
    }

    private void addUsernameAndPassword(Composite parent) {
        Label usernameLabel = new Label(parent, 16384);
        usernameLabel.setText(Messages.ConnectionWizardPage_USER_CAPTION);
        usernameLabel.setToolTipText(Messages.ConnectionWizardPage_USER_TOOLTIP);
        this.usernameField = new Text(parent, 2052);
        GridData data = new GridData(4, 0x1000000, true, false);
        this.usernameField.setLayoutData((Object)data);
        this.usernameField.setData("name", (Object)USERNAME_FIELD_NAME);
        ConnectionWizardPage.selectAllOnFocus(this.usernameField);
        Label passwordLabel = new Label(parent, 16384);
        passwordLabel.setText(Messages.ConnectionWizardPage_PASSWORD_CAPTION);
        passwordLabel.setToolTipText(Messages.ConnectionWizardPage_PASSWORD_TOOLTIP);
        this.passwordField = new Text(parent, 0x400804);
        data = new GridData(4, 0x1000000, true, false);
        this.passwordField.setLayoutData((Object)data);
        this.passwordField.setData("name", (Object)PASSWORD_FIELD_NAME);
        ConnectionWizardPage.selectAllOnFocus(this.passwordField);
    }

    private void addCommandLineInfo(Composite parent) {
        this.javaCommandCaption = new Label(parent, 16384);
        this.javaCommandCaption.setText(Messages.ConnectionWizardPage_CAPTION_JAVA_COMMAND);
        this.javaCommandCaption.setToolTipText(Messages.ConnectionWizardPage_TOOLTIP_DISCOVERED_INFO);
        this.javaCommandField = new Text(parent, 2060);
        this.javaCommandField.setToolTipText(Messages.ConnectionWizardPage_TOOLTIP_DISCOVERED_INFO);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 400;
        this.javaCommandField.setLayoutData((Object)data);
    }

    private void addJVMArgsInfo(Composite parent) {
        this.jvmArgsCaption = new Label(parent, 16384);
        this.jvmArgsCaption.setText(Messages.ConnectionWizardPage_CAPTION_JVMARGS);
        this.jvmArgsCaption.setToolTipText(Messages.ConnectionWizardPage_TOOLTIP_DISCOVERED_INFO);
        this.jvmArgsField = new Text(parent, 2060);
        this.jvmArgsField.setToolTipText(Messages.ConnectionWizardPage_TOOLTIP_DISCOVERED_INFO);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 400;
        this.jvmArgsField.setLayoutData((Object)data);
    }

    private void addPidInfo(Composite parent) {
        this.pidCaption = new Label(parent, 16384);
        this.pidCaption.setText(Messages.ConnectionWizardPage_CAPTION_PID);
        this.pidCaption.setToolTipText(Messages.ConnectionWizardPage_TOOLTIP_DISCOVERED_INFO);
        this.pidField = new Text(parent, 2060);
        this.pidField.setToolTipText(Messages.ConnectionWizardPage_TOOLTIP_DISCOVERED_INFO);
        GridData data = new GridData(4, 0x1000000, true, false);
        this.pidField.setLayoutData((Object)data);
    }

    private boolean isDiscovered() {
        return this.server != null && this.server.getDiscoveryInfo() != null;
    }

    private boolean isEditable() {
        return !this.isDiscovered() && !this.isConnected();
    }

    private boolean isConnected() {
        return this.server != null && this.server.getServerHandle().getState() == IServerHandle.State.CONNECTED;
    }

    private boolean hasServiceUrl() {
        return this.server != null ? this.server.getConnectionUrl() != null : false;
    }

    private void createHostPortServiceURLComposite(Composite outer) {
        Composite inner = new Composite(outer, 0);
        GridLayout l = new GridLayout(1, false);
        inner.setLayoutData((Object)new GridData(4, 4, true, false, 2, 2));
        l.marginWidth = 0;
        l.marginHeight = 0;
        inner.setLayout((Layout)l);
        this.fieldStack = new Composite(inner, 0);
        this.fieldStack.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fieldStackLayout = new StackLayout();
        this.fieldStack.setLayout((Layout)this.fieldStackLayout);
        this.createHostPortComposite(this.fieldStack);
        this.createServiceURLComposite(this.fieldStack);
        this.createCustomURLButtonComposite(inner);
    }

    private void createCustomURLButtonComposite(Composite inner) {
        CustomURLSelector customURLSelector = new CustomURLSelector();
        this.customUrlButton = new Button(inner, 2);
        this.customUrlButton.setText(Messages.ConnectionWizardPage_BUTTON_CUSTOM_JMX_SERVICE_URL_TEXT);
        this.customUrlButton.addSelectionListener((SelectionListener)customURLSelector);
        this.customUrlButton.setLayoutData((Object)new GridData(131072, 2, false, false));
        if (this.isDiscovered()) {
            this.customUrlButton.setVisible(false);
        }
    }

    private void createServiceURLComposite(Composite parent) {
        this.serviceUrlComposite = new Composite(parent, 0);
        GridLayout l = new GridLayout(2, false);
        l.marginWidth = 0;
        l.marginHeight = 0;
        this.serviceUrlComposite.setLayout((Layout)l);
        GridData data = new GridData(768, 0x1000000, true, true);
        this.serviceUrlComposite.setLayoutData((Object)data);
        Label serviceLabel = new Label(this.serviceUrlComposite, 16384);
        serviceLabel.setText(Messages.ConnectionWizardPage_SERVICE_URL_CAPTION);
        serviceLabel.setToolTipText(Messages.ConnectionWizardPage_SERVICE_URL_TOOLTIP);
        this.serviceUrlField = new Text(this.serviceUrlComposite, 2052);
        serviceLabel.setToolTipText(Messages.ConnectionWizardPage_SERVICE_URL_TOOLTIP);
        data = new GridData(4, 0x1000000, true, false);
        this.serviceUrlField.setLayoutData((Object)data);
        ConnectionWizardPage.selectAllOnFocus(this.serviceUrlField);
    }

    private void createHostPortComposite(Composite parent) {
        this.hostNamePortFieldComposite = new Composite(parent, 0);
        GridLayout l = new GridLayout(2, false);
        l.marginWidth = 0;
        l.marginHeight = 0;
        this.hostNamePortFieldComposite.setLayout((Layout)l);
        Label hostNameLabel = new Label(this.hostNamePortFieldComposite, 16384);
        hostNameLabel.setText(Messages.ConnectionWizardPage_HOST_CAPTION);
        hostNameLabel.setToolTipText(Messages.ConnectionWizardPage_HOST_TOOLTIP);
        this.hostNameField = new Text(this.hostNamePortFieldComposite, 2052);
        GridData data = new GridData(4, 0x1000000, true, false);
        this.hostNameField.setLayoutData((Object)data);
        this.hostNameField.setData("name", (Object)HOSTNAME_FIELD_NAME);
        ConnectionWizardPage.selectAllOnFocus(this.hostNameField);
        Label portLabel = new Label(this.hostNamePortFieldComposite, 16384);
        portLabel.setText(Messages.ConnectionWizardPage_PORT_CAPTION);
        portLabel.setToolTipText(Messages.ConnectionWizardPage_PORT_TOOLTIP);
        this.portField = new Text(this.hostNamePortFieldComposite, 2052);
        data = new GridData(4, 0x1000000, true, false);
        this.portField.setLayoutData((Object)data);
        this.portField.setData("name", (Object)PORT_FIELD_NAME);
        ConnectionWizardPage.selectAllOnFocus(this.portField);
    }

    private void initializeFields() {
        String host = LOCALHOST;
        int port = ConnectionToolkit.getDefaultPort();
        String name = LOCALHOST;
        if (this.server != null) {
            this.currentUrl = this.server.getConnectionUrl();
            name = this.server.getServerHandle().getServerDescriptor().getDisplayName();
            ICredentials credential = this.server.getCredentials();
            if (credential != null) {
                try {
                    String password;
                    String username = credential.getUsername();
                    if (username != null) {
                        this.usernameField.setText(username);
                    }
                    if ((password = credential.getPassword()) != null) {
                        this.passwordField.setText(password);
                    }
                    if (this.storePasswordButton != null) {
                        this.storePasswordButton.setSelection(credential.getExportedId() != null);
                    }
                }
                catch (CredentialsNotAvailableException username) {
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.currentUrl != null) {
            host = ConnectionToolkit.getHostName((JMXServiceURL)this.currentUrl);
            port = ConnectionToolkit.getPort((JMXServiceURL)this.currentUrl);
            try {
                String defaultUrlPath = ConnectionToolkit.createServiceURL((String)host, (int)port).getURLPath();
                if (!this.currentUrl.getProtocol().equals(PROTOCOL_RMI) || !this.currentUrl.getURLPath().equals(defaultUrlPath)) {
                    this.customUrlButton.setSelection(true);
                }
            }
            catch (IOException e) {
                this.customUrlButton.setSelection(true);
                JVMBrowserPlugin.getDefault().getLogger().log(Level.FINE, e.getMessage(), e);
            }
        }
        this.connectionNameField.setText(name);
        if (this.isDiscovered()) {
            String commandLine = ServerToolkit.getJavaCommand((IServer)this.server);
            String jvmArgs = ServerToolkit.getJVMArguments((IServer)this.server);
            this.javaCommandField.setText(commandLine == null ? "" : commandLine);
            this.jvmArgsField.setText(jvmArgs == null ? "" : jvmArgs);
            Integer pid = ServerToolkit.getPid((IServerHandle)this.server.getServerHandle());
            this.pidField.setText(pid != null ? "" + pid : Messages.ConnectionWizardPage_TEXT_UNKNOWN);
            if (this.hasServiceUrl()) {
                this.showServiceUrlField();
            }
        } else {
            this.hostNameField.setText(host);
            this.portField.setText("" + port);
            this.setInputFieldsShowing(this.customUrlButton.getSelection());
            boolean bl = this.hasEditedConnectionName = !name.equals(this.generateConnectionName());
        }
        if (!this.isEditable()) {
            this.connectionNameField.setEditable(false);
            if (!this.isDiscovered()) {
                this.hostNameField.setEditable(false);
                this.portField.setEditable(false);
                this.passwordField.setEditable(false);
                this.usernameField.setEditable(false);
                this.serviceUrlField.setEditable(false);
                this.storePasswordButton.setEnabled(false);
            }
        }
    }

    private void checkIsPageComplete() {
        String warningMessage = null;
        if (!this.isEditable()) {
            this.setErrorMessage(null);
            this.setMessage(this.isDiscovered() ? Messages.ConnectionWizardPage_MESSAGE_LOCAL_CONNECTION : Messages.ConnectionWizardPage_MESSAGE_CONNECTED);
            this.setPageComplete(false);
            return;
        }
        if (this.customUrlButton.getSelection()) {
            try {
                this.currentUrl = new JMXServiceURL(this.serviceUrlField.getText());
                if (this.checkServerWithSameUrl(this.currentUrl)) {
                    warningMessage = Messages.ConnectionWizardPage_INFO_MESSAGE_SAME_URL;
                }
                this.setErrorMessage(null);
            }
            catch (MalformedURLException ex) {
                this.setError(NLS.bind((String)Messages.ConnectionWizardPage_ERROR_MESSAGE_NOT_VALID_SERVICE_URL, (Object)ex.getLocalizedMessage()));
                return;
            }
        }
        try {
            int port = Integer.parseInt(this.portField.getText());
            if (port < 0 || port > 65535) {
                this.setError(NLS.bind((String)Messages.ConnectionWizardPage_ERROR_INVALID_PORT, (Object)String.valueOf(port)));
                return;
            }
        }
        catch (NumberFormatException e) {
            this.setError(Messages.ConnectionWizardPage_ERROR_MESSAGE_PORT_MUST_BE_INTEGER);
            return;
        }
        if (this.checkServerWithSameHostPort(this.getPort(), this.getHostName())) {
            warningMessage = Messages.ConnectionWizardPage_INFO_MESSAGE_SAME_HOST_PORT;
        }
        try {
            IConnectionDescriptor props = new ConnectionDescriptorBuilder().hostName(this.getHostName()).port(this.getPort()).build();
            JMXServiceURL tmpUrl = props.createJMXServiceURL();
            this.currentUrl = new JMXServiceURL(tmpUrl.toString());
        }
        catch (IOException ex) {
            this.setError(NLS.bind((String)Messages.ConnectionWizardPage_ERROR_MESSAGE_NOT_VALID_SERVICE_URL, (Object)ex.getLocalizedMessage()));
            return;
        }
        if (warningMessage == null && this.checkServerWithSameName(this.getConnectionName())) {
            warningMessage = NLS.bind((String)Messages.ConnectionWizardPage_INFO_MESSAGE_NAME_ALREADY_EXIST, (Object)this.getConnectionName());
        }
        this.setErrorMessage(null);
        this.setMessage(warningMessage != null ? warningMessage : Messages.ConnectionWizardPage_MESSAGE_ENTER_CONNECTION_DETAILS, warningMessage != null ? 1 : 0);
        this.setPageComplete(true);
    }

    private boolean checkServerWithSameName(String connectionName) {
        if (this.server == null) {
            Server[] serverArray = this.model.serverModel.elements();
            int n = serverArray.length;
            int n2 = 0;
            while (n2 < n) {
                Server s = serverArray[n2];
                if (connectionName.equals(s.getServerHandle().getServerDescriptor().getDisplayName())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean checkServerWithSameHostPort(int port, String host) {
        if (this.server == null) {
            Server[] serverArray = this.model.serverModel.elements();
            int n = serverArray.length;
            int n2 = 0;
            while (n2 < n) {
                Server s = serverArray[n2];
                JMXServiceURL url = s.getConnectionUrl();
                if (url != null && host.equals(ConnectionToolkit.getHostName((JMXServiceURL)url)) && port == ConnectionToolkit.getPort((JMXServiceURL)url)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean checkServerWithSameUrl(JMXServiceURL currentUrl) {
        if (this.server == null) {
            Server[] serverArray = this.model.serverModel.elements();
            int n = serverArray.length;
            int n2 = 0;
            while (n2 < n) {
                Server s = serverArray[n2];
                JMXServiceURL url = s.getConnectionUrl();
                if (url != null && currentUrl.equals(url)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void setError(String errorMessage) {
        this.setMessage(null);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(false);
    }

    void updateModel() {
        if (this.isEditable()) {
            try {
                Server newServer;
                String username = this.getUsername();
                String password = this.getPassword();
                boolean storePassword = this.getStorePassword();
                String connectionName = this.getConnectionName();
                ServerModelCredentials credentials = new ServerModelCredentials(username, password, storePassword);
                IConnectionDescriptor cd = new ConnectionDescriptorBuilder().url(this.currentUrl).credentials((ICredentials)credentials).build();
                if (this.server != null) {
                    ServerDescriptor sd = new ServerDescriptor(this.server.getServerHandle().getServerDescriptor(), connectionName);
                    newServer = new Server(this.server.getPath(), this.currentUrl, (ICredentials)credentials, this.server.getDiscoveryInfo(), (IServerDescriptor)sd, cd);
                } else {
                    ServerDescriptor sd = new ServerDescriptor(null, connectionName, null);
                    newServer = new Server(this.serverPath, this.currentUrl, (ICredentials)credentials, null, (IServerDescriptor)sd, cd);
                }
                this.model.createdServer = newServer;
                this.model.connectToServer = newServer;
            }
            catch (SecurityException e) {
                UIPlugin.getDefault().getLogger().log(Level.FINE, "Could not build a IConnectionDescriptor", e);
                MessageDialog.openWarning((Shell)this.getShell(), (String)com.oracle.jmc.ui.security.Messages.SecurityDialogs_UNABLE_TO_CONTINUE, (String)Messages.ConnectionWizard_EXCEPTION_COULD_NOT_STORE_CONNECTION);
            }
        }
    }

    private Exception testConnection() {
        if (this.model.createdServer == null) {
            this.updateModel();
            ConnectionTester ct = new ConnectionTester((IServerHandle)this.model.createdServer.getServerHandle());
            JVMBrowserPlugin.getDefault().runProgressTask(false, true, false, ct);
            if (ct.exception != null) {
                this.model.createdServer = null;
            }
            return ct.exception;
        }
        return null;
    }

    private void setConnectionFailed() {
        this.connectionFailed = true;
        this.setPageComplete(true);
    }

    private String generateConnectionName() {
        if (Integer.toString(ConnectionToolkit.getDefaultPort()).equals(this.portField.getText().trim())) {
            return this.hostNameField.getText().trim();
        }
        return String.valueOf(this.hostNameField.getText().trim()) + ":" + this.portField.getText().trim();
    }

    private static void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = ncol;
        line.setLayoutData((Object)gridData);
    }

    private int getPort() {
        try {
            return Integer.parseInt(this.portField.getText());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private String getConnectionName() {
        return this.connectionNameField.getText().trim();
    }

    private String getUsername() {
        return this.usernameField.getText().trim();
    }

    private String getPassword() {
        if (this.passwordField.getText().trim() != null && !this.passwordField.getText().trim().equals("")) {
            return this.passwordField.getText().trim();
        }
        return null;
    }

    private boolean getStorePassword() {
        return this.storePasswordButton.getSelection();
    }

    private String getHostName() {
        return this.hostNameField.getText().trim();
    }

    public IWizardPage getNextPage() {
        Exception e = this.testConnection();
        if (e != null) {
            DialogToolkit.showException((Shell)this.getControl().getShell(), (String)Messages.ConnectionWizardPage_STATUS_IS_NOT_CONNECTED, (String)NLS.bind((String)Messages.ConnectionWizardPage_COULD_NOT_CONNECT_DISABLE_NEXT, (Object)this.getConnectionName()), (Throwable)e);
            return null;
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return !this.connectionFailed && super.canFlipToNextPage();
    }

    private static class ConnectionTester
    implements IRunnableWithProgress {
        IServerHandle sh;
        Exception exception;

        ConnectionTester(IServerHandle sh) {
            this.sh = sh;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.ConnectionWizardPage_TESTING_CONNECTION_CAPTION, 1);
            try {
                try {
                    this.sh.connect(Messages.ConnectionWizardPage_TESTING_CONNECTION_CAPTION).close();
                    monitor.worked(1);
                }
                catch (Exception e) {
                    this.exception = e;
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private class CustomURLSelector
    extends SelectionAdapter {
        private CustomURLSelector() {
        }

        public void widgetSelected(SelectionEvent e) {
            ConnectionWizardPage.this.setInputFieldsShowing(ConnectionWizardPage.this.customUrlButton.getSelection());
        }
    }

    private class InputVerifier
    implements ModifyListener {
        private InputVerifier() {
        }

        public void modifyText(ModifyEvent e) {
            if (!ConnectionWizardPage.this.enableTextVerifier) {
                return;
            }
            if (e.getSource() == ConnectionWizardPage.this.connectionNameField) {
                ConnectionWizardPage.this.hasEditedConnectionName = true;
            } else {
                ((ConnectionWizardPage)ConnectionWizardPage.this).model.createdServer = null;
                ConnectionWizardPage.this.connectionFailed = false;
                ConnectionWizardPage.this.testConnectionStatusText.setText(Messages.ConnectionWizardPage_STATUS_IS_UNTESTED);
            }
            if (e.getSource() == ConnectionWizardPage.this.serviceUrlField) {
                ConnectionWizardPage.this.enableTextVerifier = false;
                ConnectionWizardPage.this.updateHostAndPortFromServiceURL();
                ConnectionWizardPage.this.enableTextVerifier = true;
            }
            if (!ConnectionWizardPage.this.hasEditedConnectionName) {
                ConnectionWizardPage.this.enableTextVerifier = false;
                ConnectionWizardPage.this.connectionNameField.setText(ConnectionWizardPage.this.generateConnectionName());
                ConnectionWizardPage.this.enableTextVerifier = true;
            }
            ConnectionWizardPage.this.checkIsPageComplete();
        }
    }
}

