/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.browser.wizards;

import com.oracle.jmc.browser.JVMBrowserPlugin;
import com.oracle.jmc.browser.wizards.ActionWizardPage;
import com.oracle.jmc.browser.wizards.ConnectionSelectionWizardPage;
import com.oracle.jmc.browser.wizards.ConnectionWizardModel;
import com.oracle.jmc.browser.wizards.ConnectionWizardPage;
import com.oracle.jmc.browser.wizards.Messages;
import com.oracle.jmc.core.AdapterUtil;
import com.oracle.jmc.core.UserActionJob;
import com.oracle.jmc.rjmx.servermodel.internal.Server;
import com.oracle.jmc.ui.misc.DialogToolkit;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ConnectionWizard
extends Wizard
implements INewWizard {
    private static final String SECTION_CONNECTION_WIZARD = "com.oracle.jmc.browser.wizards.ConnectionWizard";
    private final Server server;
    private final String serverPath;
    private final boolean startOnNewConnectionPage;
    private final ConnectionWizardModel serverConnectModel;

    public ConnectionWizard() {
        this(null);
    }

    private ConnectionWizard(String serverPath) {
        this(null, serverPath, true, Messages.ConnectionWizard_TITLE_NEW_CONNECTION);
    }

    public static void opeNewServerWizard(String serverPath) {
        DialogToolkit.openWizardWithHelp((IWizard)new ConnectionWizard(serverPath));
    }

    public static void openPropertiesWizard(Server server) {
        DialogToolkit.openWizardWithHelp((IWizard)new ConnectionWizard(server, null, true, Messages.ConnectionWizard_TITLE_CONNECTION_PROPERTIES));
    }

    public static void openConnectWizard() {
        DialogToolkit.openWizardWithHelp((IWizard)new ConnectionWizard(null, null, false, Messages.ConnectionWizard_TITLE_CONNECT));
    }

    private ConnectionWizard(Server server, String serverPath, boolean startOnNewConnectionPage, String title) {
        this.server = server;
        this.serverPath = serverPath;
        this.setNeedsProgressMonitor(false);
        this.initializeDefaultPageImageDescriptor();
        this.initializeDialogSettings();
        this.startOnNewConnectionPage = startOnNewConnectionPage;
        this.serverConnectModel = new ConnectionWizardModel();
        this.setWindowTitle(title);
    }

    private void initializeDialogSettings() {
        IDialogSettings wizardSettings = JVMBrowserPlugin.getDefault().getDialogSettings().getSection(SECTION_CONNECTION_WIZARD);
        if (wizardSettings == null) {
            JVMBrowserPlugin.getDefault().getDialogSettings().addNewSection(SECTION_CONNECTION_WIZARD);
        }
        this.setDialogSettings(wizardSettings);
    }

    private void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(JVMBrowserPlugin.getDefault().getMCImageDescriptor("bannerconwiz.gif"));
    }

    public boolean performFinish() {
        if (this.getConnectionWizardPage().isTheCurrentPage()) {
            this.getConnectionWizardPage().updateModel();
        } else if (this.serverConnectModel.action != null && !AdapterUtil.hasAdapter((Object)this.serverConnectModel.action, IWizard.class)) {
            new UserActionJob(this.serverConnectModel.action).schedule();
        }
        if (this.serverConnectModel.createdServer != null) {
            this.serverConnectModel.serverModel.insert(new Server[]{this.serverConnectModel.createdServer});
        }
        return true;
    }

    public boolean canFinish() {
        if (this.getConnectionSelectionWizardPage().isTheCurrentPage()) {
            return false;
        }
        if (this.getConnectionWizardPage().isTheCurrentPage()) {
            return this.getConnectionWizardPage().isPageComplete();
        }
        if (this.getUserActionWizardPage().isTheCurrentPage()) {
            return this.getUserActionWizardPage().isPageComplete();
        }
        return false;
    }

    public void addPages() {
        this.addPage((IWizardPage)new ConnectionSelectionWizardPage(this.serverConnectModel));
        this.addPage((IWizardPage)new ConnectionWizardPage(this.server, this.serverPath, this.serverConnectModel));
        this.addPage((IWizardPage)new ActionWizardPage(this.serverConnectModel));
        if (this.startOnNewConnectionPage) {
            this.getConnectionWizardPage().setPreviousPage(null);
            this.getConnectionWizardPage().setNextPage((IWizardPage)this.getUserActionWizardPage());
            this.getUserActionWizardPage().setPreviousPage((IWizardPage)this.getConnectionWizardPage());
        } else {
            this.getConnectionSelectionWizardPage().setNextPage((IWizardPage)this.getUserActionWizardPage());
            this.getUserActionWizardPage().setPreviousPage((IWizardPage)this.getConnectionSelectionWizardPage());
        }
        if (this.server != null) {
            this.getConnectionWizardPage().setPreviousPage(null);
            this.getConnectionWizardPage().setNextPage(null);
        }
    }

    ConnectionSelectionWizardPage getConnectionSelectionWizardPage() {
        return (ConnectionSelectionWizardPage)this.getPage("com.oracle.jmc.browser.server.connect.server.selection");
    }

    ConnectionWizardPage getConnectionWizardPage() {
        return (ConnectionWizardPage)this.getPage(ConnectionWizardPage.PAGE_NAME);
    }

    ActionWizardPage getUserActionWizardPage() {
        return (ActionWizardPage)this.getPage("com.oracle.jmc.browser.server.connect.action.selection");
    }

    public IWizardPage getStartingPage() {
        return this.server != null ? this.getConnectionWizardPage() : (this.startOnNewConnectionPage ? this.getConnectionWizardPage() : this.getConnectionSelectionWizardPage());
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return page.getPreviousPage();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

