/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.browser.wizards;

import com.oracle.jmc.browser.views.BrowserLabelProvider;
import com.oracle.jmc.browser.views.Folder;
import com.oracle.jmc.browser.views.FolderStructure;
import com.oracle.jmc.browser.views.JVMBrowserView;
import com.oracle.jmc.browser.wizards.ConnectionWizard;
import com.oracle.jmc.browser.wizards.ConnectionWizardModel;
import com.oracle.jmc.browser.wizards.ConnectionWizardPage;
import com.oracle.jmc.browser.wizards.Messages;
import com.oracle.jmc.browser.wizards.NewConnectionNode;
import com.oracle.jmc.rjmx.servermodel.IServer;
import com.oracle.jmc.ui.misc.TreeStructureContentProvider;
import com.oracle.jmc.ui.wizards.RelinkableWizardPage;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ConnectionSelectionWizardPage
extends RelinkableWizardPage
implements Observer {
    static final String PAGE_NAME = "com.oracle.jmc.browser.server.connect.server.selection";
    private TreeViewer treeViewer;
    private Object selectedNode;
    private final ConnectionWizardModel serverConnectModel;

    public ConnectionSelectionWizardPage(ConnectionWizardModel serverConnectModel) {
        super(PAGE_NAME, Messages.ServerConnectWizardPage_SERVER_SELECT_DESCRIPTION, null);
        this.serverConnectModel = serverConnectModel;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        this.treeViewer = new TreeViewer(container, 2820);
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.treeViewer.setAutoExpandLevel(3);
        this.treeViewer.setContentProvider((IContentProvider)new TreeStructureContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] existing = super.getElements(inputElement);
                Object[] elements = new Object[existing.length + 1];
                elements[0] = new NewConnectionNode();
                System.arraycopy(existing, 0, elements, 1, existing.length);
                return elements;
            }
        });
        this.treeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof NewConnectionNode) {
                    return 0;
                }
                if (element instanceof Folder) {
                    return ((Folder)element).isModifiable() ? 2 : 1;
                }
                return 3;
            }
        });
        this.serverConnectModel.serverModel.addObserver((Observer)this);
        this.treeViewer.setInput((Object)new FolderStructure(this.serverConnectModel.serverModel, null));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new BrowserLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConnectionSelectionWizardPage.this.select((IStructuredSelection)event.getSelection());
            }
        });
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.oracle.jmc.browser.select_server");
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.oracle.jmc.browser.select_server");
    }

    @Override
    public void update(Observable o, final Object element) {
        Display.getDefault().asyncExec(new Runnable(){
            boolean runAgain = true;

            @Override
            public void run() {
                if (!ConnectionSelectionWizardPage.this.treeViewer.getTree().isDisposed()) {
                    ConnectionSelectionWizardPage.this.treeViewer.refresh(element);
                    if (this.runAgain) {
                        this.runAgain = false;
                        Display.getCurrent().timerExec(JVMBrowserView.getHighlightTime(), (Runnable)this);
                    }
                }
            }
        });
    }

    public void dispose() {
        this.serverConnectModel.serverModel.deleteObserver((Observer)this);
        super.dispose();
    }

    private void select(IStructuredSelection ss) {
        if (!ss.isEmpty()) {
            this.selectedNode = ss.getFirstElement();
            if (this.selectedNode instanceof IServer) {
                this.serverConnectModel.connectToServer = (IServer)this.selectedNode;
            }
        }
        this.setPageComplete(this.isServerSelected());
    }

    private boolean isServerSelected() {
        return this.selectedNode instanceof IServer || this.selectedNode instanceof NewConnectionNode;
    }

    public boolean isPageComplete() {
        return this.isServerSelected();
    }

    public IWizardPage getNextPage() {
        if (this.selectedNode instanceof NewConnectionNode) {
            ConnectionWizardPage cwp = ((ConnectionWizard)this.getWizard()).getConnectionWizardPage();
            cwp.setPreviousPage((IWizardPage)this);
            cwp.setNextPage(super.getNextPage());
            return cwp;
        }
        return super.getNextPage();
    }
}

