/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.browser.views;

import com.oracle.jmc.attach.AttachToolkit;
import com.oracle.jmc.browser.JVMBrowserPlugin;
import com.oracle.jmc.browser.attach.LocalJVMToolkit;
import com.oracle.jmc.browser.views.Messages;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class NoLocalJVMsWarner {
    public static void warnIfNoLocalJVMs(final Control control) {
        PaintListener noLocalJVMWarner = new PaintListener(){

            public void paintControl(PaintEvent e) {
                control.removePaintListener((PaintListener)this);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (!AttachToolkit.isLocalAttachAvailable() || LocalJVMToolkit.getAttachableJVMs().length == 0) {
                            NoLocalJVMsWarner.showNoLocalJVMsWarning(control);
                        }
                    }
                }).start();
            }
        };
        control.addPaintListener(noLocalJVMWarner);
    }

    private static void showNoLocalJVMsWarning(final Control control) {
        DisplayToolkit.safeAsyncExec((Widget)control, (Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialogWithToggle warnDialog = MessageDialogWithToggle.openWarning((Shell)control.getShell(), (String)Messages.JVMBrowserView_NO_LOCAL_JVMS_TITLE, (String)(String.valueOf(Messages.JVMBrowserView_NO_LOCAL_JVMS_MESSAGE) + System.getProperty("line.separator") + Messages.JVMBrowserView_NO_LOCAL_JVMS_WARN_CAUSE), (String)Messages.JVMBrowserView_NO_LOCAL_JVMS_WARN_PREFERENCE, (boolean)true, null, null);
                if (warnDialog.getReturnCode() == 0 && !warnDialog.getToggleState()) {
                    JVMBrowserPlugin.getDefault().setWarnNoLocalJVMs(false);
                }
            }
        });
    }
}

