/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.browser.views;

import com.oracle.jmc.browser.JVMBrowserPlugin;
import com.oracle.jmc.browser.views.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

abstract class NewFolderAction
extends Action {
    NewFolderAction() {
        this.setId("new.folder");
        this.setText(Messages.JVMBrowserView_ACTION_NEW_FOLDER_TEXT);
        this.setToolTipText(Messages.JVMBrowserView_ACTION_NEW_FOLDER_TOOLTIP);
        this.setImageDescriptor(JVMBrowserPlugin.getDefault().getMCImageDescriptor("newfolder.gif"));
    }

    public void run() {
        InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.JVMBrowserView_DIALOG_NEW_FOLDER_TITLE, Messages.JVMBrowserView_DIALOG_NEW_FOLDER_TEXT, Messages.JVMBrowserView_DIALOG_NEW_FOLDER_DEFAULT_VALUE, NewFolderAction.createFolderStringValidator());
        dlg.open();
        if (dlg.getReturnCode() == 0) {
            this.onNewFolder(dlg.getValue());
        }
    }

    public void setEnabled(boolean enabled) {
        this.setToolTipText(enabled ? Messages.JVMBrowserView_ACTION_NEW_FOLDER_TOOLTIP : Messages.JVMBrowserView_ACTION_NEW_FOLDER_DISABLED_TOOLTIP);
        super.setEnabled(enabled);
    }

    protected abstract void onNewFolder(String var1);

    static IInputValidator createFolderStringValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                int i = 0;
                while (i < newText.length()) {
                    char c = newText.charAt(i);
                    if (!Character.isDigit(c) && !Character.isLetter(c) && c != ' ' && c != '_' && c != '-') {
                        return Messages.JVMBrowserView_DIALOG_NEW_FOLDER_ERROR_MESSAGE_VALIDATION;
                    }
                    ++i;
                }
                return null;
            }
        };
    }
}

