/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.browser.views;

import com.oracle.jmc.browser.JVMBrowserPlugin;
import com.oracle.jmc.browser.views.BrowserContentProvider;
import com.oracle.jmc.browser.views.BrowserLabelProvider;
import com.oracle.jmc.browser.views.DisconnectAction;
import com.oracle.jmc.browser.views.Folder;
import com.oracle.jmc.browser.views.FolderDndSupport;
import com.oracle.jmc.browser.views.FolderStructure;
import com.oracle.jmc.browser.views.Messages;
import com.oracle.jmc.browser.views.MultipleActionWrapper;
import com.oracle.jmc.browser.views.NewConnectionAction;
import com.oracle.jmc.browser.views.NewFolderAction;
import com.oracle.jmc.browser.views.NoLocalJVMsWarner;
import com.oracle.jmc.browser.views.UserActionWrapper;
import com.oracle.jmc.browser.wizards.ConnectionWizard;
import com.oracle.jmc.common.internal.IActionProvider;
import com.oracle.jmc.common.internal.IDisconnectable;
import com.oracle.jmc.common.internal.IUserAction;
import com.oracle.jmc.core.UserActionJob;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.IServerHandle;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.servermodel.IServer;
import com.oracle.jmc.rjmx.servermodel.internal.Server;
import com.oracle.jmc.rjmx.servermodel.internal.ServerModel;
import com.oracle.jmc.ui.accessibility.AccessibilityToolkit;
import com.oracle.jmc.ui.handlers.ActionToolkit;
import com.oracle.jmc.ui.misc.DialogToolkit;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import com.oracle.jmc.ui.misc.IRefreshable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class JVMBrowserView
extends ViewPart
implements Observer {
    private static final String USE_TREE_LAYOUT_MEMENTO_TYPE = "UseTreeLayout";
    public static final String JVMBrowserView_TREE_NAME = "com.oracle.jmc.browser.views.JVMBrowserTree";
    private TreeViewer viewer;
    private Object[] backgroundExpandState = new Object[0];
    private volatile Object[] expanded = new Object[0];
    private volatile boolean useTreeLayout;
    private FolderStructure folderStructure;
    private final ServerModel model = (ServerModel)RJMXPlugin.getDefault().getService(ServerModel.class);
    private final Future<?> refresher = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

        @Override
        public void run() {
            Object[] exp = JVMBrowserView.this.expanded;
            int i = 0;
            while (i < exp.length) {
                if (exp[i] instanceof IRefreshable) {
                    final IRefreshable c = (IRefreshable)exp[i];
                    try {
                        if (c.refresh()) {
                            JVMBrowserView.this.refreshTree(c);
                        }
                    }
                    catch (RuntimeException e) {
                        final String problematicNode = exp[i].toString();
                        exp[i] = null;
                        DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                JVMBrowserView.this.setExpanded(c, false);
                                DialogToolkit.showException((Shell)JVMBrowserView.this.viewer.getControl().getShell(), (String)NLS.bind((String)Messages.JVMBrowserView_DIALOG_TITLE_PROBLEM_CONNECT, (Object)problematicNode), (Throwable)e);
                            }
                        });
                    }
                }
                ++i;
            }
        }
    }, 1L, 1L, TimeUnit.SECONDS);
    private final Action newFolderAction = new NewFolderAction(){

        @Override
        protected void onNewFolder(String name) {
            JVMBrowserView.this.folderStructure.addFolder(name);
            JVMBrowserView.this.refreshTree(null);
        }
    };
    private final ISelectionChangedListener handlerEnablementListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = JVMBrowserView.this.getStructuredSelection();
            boolean canDelete = false;
            for (Object o : selection.toList()) {
                if (o instanceof IServer && ((IServer)o).getDiscoveryInfo() == null || o instanceof Folder && ((Folder)o).isModifiable()) {
                    canDelete = true;
                    continue;
                }
                canDelete = false;
                break;
            }
            JVMBrowserView.this.deleteHandler.setEnabled(canDelete);
            JVMBrowserView.this.propertiesHandler.setEnabled(selection.size() == 1 && (canDelete || selection.getFirstElement() instanceof Server));
        }
    };
    private final IAction deleteHandler = ActionToolkit.commandAction(this::deleteSelected, (String)"org.eclipse.ui.edit.delete");
    private final IAction propertiesHandler = ActionToolkit.commandAction(this::showPropertiesForSelected, (String)"org.eclipse.ui.file.properties");

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        Boolean useTreeLayout;
        this.folderStructure = new FolderStructure(this.model, memento);
        if (memento != null && (useTreeLayout = memento.getBoolean(USE_TREE_LAYOUT_MEMENTO_TYPE)) != null) {
            this.useTreeLayout = useTreeLayout;
        }
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        this.folderStructure.saveState(memento);
        memento.putBoolean(USE_TREE_LAYOUT_MEMENTO_TYPE, this.useTreeLayout);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.getTree().setData("name", (Object)JVMBrowserView_TREE_NAME);
        this.viewer.setLabelProvider((IBaseLabelProvider)new BrowserLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new BrowserContentProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return element instanceof Folder ? (((Folder)element).isModifiable() ? 1 : 0) : 2;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                return e1 instanceof IActionProvider && e2 instanceof IActionProvider ? 0 : super.compare(viewer, e1, e2);
            }
        });
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), this.deleteHandler);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), this.propertiesHandler);
        this.getViewSite().getActionBars().updateActionBars();
        this.viewer.addSelectionChangedListener(this.handlerEnablementListener);
        this.model.addObserver((Observer)this);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "com.oracle.jmc.browser.tree");
        MenuManager mm = new MenuManager("#PopupMenu");
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JVMBrowserView.this.fillContextMenu(manager);
            }
        });
        this.hookDoubleClickListener();
        this.hookTreeListener();
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        new FolderDndSupport(this.viewer, this.folderStructure.getRootFolder()){

            @Override
            protected boolean isMoveable(Object item, Object target) {
                if (item instanceof IServer) {
                    return ((IServer)item).getDiscoveryInfo() == null || !(target instanceof Folder);
                }
                return super.isMoveable(item, target);
            }
        };
        this.useTreeLayout(this.useTreeLayout);
        AccessibilityToolkit.makeAccessibleFromTooltip((Control)this.viewer.getTree());
        NoLocalJVMsWarner.warnIfNoLocalJVMs(this.viewer.getControl());
        this.refreshTree(null, true);
    }

    private void useTreeLayout(boolean useTreeLayout) {
        Object[] bgState = this.backgroundExpandState;
        this.backgroundExpandState = this.viewer.getExpandedElements();
        this.viewer.setInput((Object)(useTreeLayout ? this.folderStructure : this.model));
        this.viewer.setExpandedElements(bgState);
        this.newFolderAction.setEnabled(useTreeLayout);
        this.useTreeLayout = useTreeLayout;
    }

    private void hookDoubleClickListener() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IUserAction defaultAction;
                Object elem = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (elem instanceof IActionProvider && (defaultAction = ((IActionProvider)elem).getDefaultAction()) != null) {
                    new UserActionJob(defaultAction).schedule();
                    return;
                }
                if (elem != null) {
                    JVMBrowserView.this.setExpanded(elem, !JVMBrowserView.this.viewer.getExpandedState(elem));
                }
            }
        });
    }

    private void hookTreeListener() {
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JVMBrowserView.this.expanded = JVMBrowserView.this.viewer.getVisibleExpandedElements();
                    }
                });
            }

            public void treeExpanded(TreeExpansionEvent event) {
                DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JVMBrowserView.this.expanded = JVMBrowserView.this.viewer.getVisibleExpandedElements();
                    }
                });
            }
        });
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)new Action(Messages.JVMBrowserView_ACTION_TREE_LAYOUT_TEXT, 2){
            {
                this.setId("tree");
                this.setToolTipText(Messages.JVMBrowserView_ACTION_TREE_LAYOUT_TOOLTIP);
                this.setImageDescriptor(JVMBrowserPlugin.getDefault().getMCImageDescriptor("tree_mode.png"));
                this.setChecked(JVMBrowserView.this.useTreeLayout);
            }

            public void run() {
                JVMBrowserView.this.useTreeLayout(this.isChecked());
            }
        });
        manager.add((IAction)new NewConnectionAction());
        manager.add((IAction)this.newFolderAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            manager.add((IAction)new NewConnectionAction());
            manager.add((IAction)this.newFolderAction);
        } else {
            this.addActions(manager, selection);
        }
    }

    private void addActions(IMenuManager manager, IStructuredSelection selection) {
        Map<String, List<Action>> commonUserActions = this.findCommonActions(selection.toList());
        Class<?> lastType = null;
        Class<?> currType = null;
        if (commonUserActions != null) {
            for (Map.Entry<String, List<Action>> actionEntry : commonUserActions.entrySet()) {
                currType = actionEntry.getValue().get(0).getClass();
                if (UserActionWrapper.class.equals(currType) && !UserActionWrapper.class.equals(lastType) || UserActionWrapper.class.equals(lastType) && !UserActionWrapper.class.equals(currType)) {
                    manager.add((IContributionItem)new Separator());
                }
                lastType = currType;
                MultipleActionWrapper multipleAction = new MultipleActionWrapper(actionEntry.getValue());
                manager.add((IAction)multipleAction);
            }
        }
        if (this.deleteHandler.isEnabled()) {
            manager.add((IContributionItem)new Separator());
            manager.add(this.deleteHandler);
        }
        if (this.propertiesHandler.isEnabled()) {
            manager.add((IContributionItem)new Separator());
            manager.add(this.propertiesHandler);
        }
    }

    private Map<String, List<Action>> findCommonActions(List<?> selection) {
        Object first = selection.get(0);
        LinkedHashMap<String, List<Action>> commonActions = new LinkedHashMap<String, List<Action>>();
        for (Action action : this.getActions(first)) {
            ArrayList list = new ArrayList();
            commonActions.put(action.getText(), list);
        }
        for (Object selected : selection) {
            Iterator iter = commonActions.entrySet().iterator();
            while (iter.hasNext()) {
                boolean hasType = false;
                Map.Entry entry = iter.next();
                for (Action action : this.getActions(selected)) {
                    if (!((String)entry.getKey()).equals(action.getText())) continue;
                    ((List)commonActions.get(action.getText())).add(action);
                    hasType = true;
                }
                if (hasType) continue;
                iter.remove();
            }
        }
        return commonActions;
    }

    private List<Action> getActions(Object o) {
        return o instanceof IActionProvider ? this.getActions((IActionProvider)o) : (o instanceof IServer ? this.getServerActions((IServer)o) : (o instanceof Folder ? this.getFolderActions((Folder)o) : null));
    }

    private List<Action> getActions(final IActionProvider ap) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (IUserAction userAction : ap.getActions()) {
            actions.add(new UserActionWrapper(userAction));
        }
        if (ap instanceof IDisconnectable && ((IDisconnectable)ap).isConnected()) {
            actions.add(new DisconnectAction(){

                public void run() {
                    JVMBrowserView.this.setExpanded(ap, false);
                    ((IDisconnectable)ap).disconnect();
                }
            });
        }
        return actions;
    }

    private List<Action> getServerActions(final IServer server) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (IUserAction userAction : server.getActionProvider().getActions()) {
            actions.add(new UserActionWrapper(userAction));
        }
        if (server.getServerHandle().getState() == IServerHandle.State.CONNECTED) {
            actions.add(new DisconnectAction(){

                public void run() {
                    StringBuilder message = new StringBuilder(Messages.JVMBrowserView_ACTION_DISCONNECT_HEADER);
                    IConnectionHandle[] iConnectionHandleArray = server.getConnectionHandles();
                    int n = iConnectionHandleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConnectionHandle handle = iConnectionHandleArray[n2];
                        message.append("\n - ").append(handle.getDescription());
                        ++n2;
                    }
                    if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.JVMBrowserView_ACTION_DISCONNECT_TEXT, (String)message.toString())) {
                        server.reset();
                        JVMBrowserView.this.setExpanded(server, false);
                    }
                }
            });
        }
        return actions;
    }

    private List<Action> getFolderActions(final Folder folder) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (folder.isModifiable()) {
            actions.add(new NewConnectionAction(folder.getPath(true)){

                @Override
                public void run() {
                    super.run();
                    JVMBrowserView.this.setExpanded(folder, true);
                }
            });
            actions.add(new NewFolderAction(){

                @Override
                protected void onNewFolder(String name) {
                    folder.getFolder(name);
                    JVMBrowserView.this.setExpanded(folder, true);
                }
            });
        }
        return actions;
    }

    protected void setExpanded(Object elem, boolean isExpanded) {
        this.viewer.refresh();
        this.viewer.setExpandedState(elem, isExpanded);
        this.expanded = this.viewer.getVisibleExpandedElements();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.refresher.cancel(true);
        super.dispose();
    }

    public void refreshTree(Object element) {
        this.refreshTree(element, false);
    }

    public void refreshTree(final Object element, boolean runTwice) {
        Display.getDefault().asyncExec(new Runnable(runTwice){
            boolean runAgain;
            {
                this.runAgain = bl;
            }

            @Override
            public void run() {
                if (!JVMBrowserView.this.viewer.getTree().isDisposed()) {
                    JVMBrowserView.this.viewer.refresh(element);
                    JVMBrowserView.this.expanded = JVMBrowserView.this.viewer.getVisibleExpandedElements();
                    if (this.runAgain) {
                        this.runAgain = false;
                        Display.getCurrent().timerExec(JVMBrowserView.getHighlightTime(), (Runnable)this);
                    }
                }
            }
        });
    }

    @Override
    public void update(Observable o, Object arg) {
        this.refreshTree(arg, true);
    }

    public static int getHighlightTime() {
        return JVMBrowserPlugin.getDefault().getPreferenceStore().getInt("highlightPreference");
    }

    static boolean isConfirmDeletes() {
        return JVMBrowserPlugin.getDefault().getPreferenceStore().getBoolean("confirmDeleteNodesPreference");
    }

    private IStructuredSelection getStructuredSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    private void deleteSelected() {
        IStructuredSelection selection = this.getStructuredSelection();
        String questionText = Messages.JVMBrowserView_DIALOG_REMOVE_MULTIPLE_TEXT;
        if (selection.size() == 1) {
            Object o = selection.getFirstElement();
            String name = o instanceof IServer ? ((IServer)o).getServerHandle().getServerDescriptor().getDisplayName() : (o instanceof Folder ? ((Folder)o).getName() : null);
            questionText = NLS.bind((String)Messages.JVMBrowserView_DIALOG_REMOVE_TEXT, (Object)name);
        }
        if (JVMBrowserView.isConfirmDeletes() && !DialogToolkit.openQuestionOnUiThread((String)Messages.JVMBrowserView_DIALOG_REMOVE_TITLE, (String)questionText)) {
            return;
        }
        ArrayList<IServer> serversToRemove = new ArrayList<IServer>();
        for (Object o : selection.toList()) {
            if (o instanceof Folder) {
                ((Folder)o).dispose();
                continue;
            }
            if (!(o instanceof IServer)) continue;
            serversToRemove.add((IServer)o);
        }
        this.model.remove(serversToRemove.toArray(new IServer[serversToRemove.size()]));
    }

    private void showPropertiesForSelected() {
        Object selected = this.getStructuredSelection().getFirstElement();
        if (selected instanceof Folder) {
            Folder folder = (Folder)selected;
            InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.JVMBrowserView_FOLDER_PROPERTIES_TITLE_TEXT, Messages.JVMBrowserView_FOLDER_NAME_TEXT, folder.getName(), NewFolderAction.createFolderStringValidator());
            dlg.open();
            if (dlg.getReturnCode() == 0) {
                folder.setName(dlg.getValue());
            }
        } else if (selected instanceof Server) {
            ConnectionWizard.openPropertiesWizard((Server)selected);
        }
    }
}

