/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.browser.views;

import com.oracle.jmc.browser.JVMBrowserPlugin;
import com.oracle.jmc.browser.views.Folder;
import com.oracle.jmc.browser.views.JVMBrowserView;
import com.oracle.jmc.browser.views.Messages;
import com.oracle.jmc.core.AdapterUtil;
import com.oracle.jmc.core.jvm.JVMDescriptor;
import com.oracle.jmc.rjmx.IServerHandle;
import com.oracle.jmc.rjmx.internal.ServerToolkit;
import com.oracle.jmc.rjmx.servermodel.IDiscoveryInfo;
import com.oracle.jmc.rjmx.servermodel.IServer;
import com.oracle.jmc.ui.misc.AdaptingLabelProvider;
import com.oracle.jmc.ui.misc.OverlayImageDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class BrowserLabelProvider
extends AdaptingLabelProvider {
    private final long highlightServersFoundAfter = System.currentTimeMillis() + 2000L;
    private final ImageDescriptor connectedOverlay = JVMBrowserPlugin.getDefault().getMCImageDescriptor("overlay_connected.png");
    private final ImageDescriptor disconnectedOverlay = JVMBrowserPlugin.getDefault().getMCImageDescriptor("overlay_disconnected.png");
    private final ImageDescriptor unconnectableOverlay = JVMBrowserPlugin.getDefault().getMCImageDescriptor("overlay_unconnectable.png");
    private final Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private final Image lockedFolderImage = (Image)this.getResourceManager().get((DeviceResourceDescriptor)new DecorationOverlayIcon(this.folderImage, JVMBrowserPlugin.getDefault().getMCImageDescriptor("padlock.png"), 3));

    public Image getImage(Object obj) {
        if (obj instanceof Folder) {
            return ((Folder)obj).isModifiable() ? this.folderImage : this.lockedFolderImage;
        }
        if (obj instanceof IServer) {
            IServer server = (IServer)obj;
            boolean connected = server.getServerHandle().getState() == IServerHandle.State.CONNECTED;
            boolean unconnectable = ServerToolkit.isUnconnectable((IServerHandle)server.getServerHandle());
            ImageDescriptor image = (ImageDescriptor)AdapterUtil.getAdapter((Object)server, ImageDescriptor.class);
            if (image != null) {
                image = new OverlayImageDescriptor(image, !connected, new ImageDescriptor[]{connected ? this.connectedOverlay : (unconnectable ? this.unconnectableOverlay : this.disconnectedOverlay)});
                return (Image)this.getResourceManager().get((DeviceResourceDescriptor)image);
            }
            return JVMBrowserPlugin.getDefault().getImage(connected ? "connect.gif" : (unconnectable ? "unconnectable.gif" : "disconnect.gif"));
        }
        return super.getImage(obj);
    }

    public Font getFont(Object o) {
        IDiscoveryInfo di;
        if (o instanceof IServer && (di = ((IServer)o).getDiscoveryInfo()) != null && di.getDiscoveredTimestamp() > this.highlightServersFoundAfter && di.getDiscoveredTimestamp() + (long)JVMBrowserView.getHighlightTime() > System.currentTimeMillis()) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }
        return super.getFont(o);
    }

    public String getText(Object element) {
        if (element instanceof Folder) {
            return ((Folder)element).getName();
        }
        if (element instanceof IServer) {
            return ((IServer)element).getServerHandle().getServerDescriptor().getDisplayName();
        }
        return super.getText(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof IServer) {
            IServerHandle serverHandle = ((IServer)element).getServerHandle();
            JVMDescriptor jvmInfo = serverHandle.getServerDescriptor().getJvmInfo();
            boolean connected = serverHandle.getState() == IServerHandle.State.CONNECTED;
            boolean unconnectable = ServerToolkit.isUnconnectable((IServerHandle)serverHandle);
            if (jvmInfo != null) {
                String tt = BrowserLabelProvider.buildTooltip(null, Messages.JVMBrowserView_COMMAND_LINE, jvmInfo.getJavaCommand());
                tt = BrowserLabelProvider.buildTooltip(tt, Messages.JVMBrowserView_JAVA_VERSION, jvmInfo.getJavaVersion());
                tt = BrowserLabelProvider.buildTooltip(tt, Messages.JVMBrowserView_TOOLTIP_PID, jvmInfo.getPid() != null ? String.valueOf(jvmInfo.getPid()) : Messages.JVMBrowserView_UNKNOWN);
                return BrowserLabelProvider.buildTooltip(tt, Messages.JVMBrowserView_CONNECTION_STATE, connected ? Messages.JVMBrowserView_CONNECTION_STATE_CONNECTED : (unconnectable ? Messages.JVMBrowserView_CONNECTION_STATE_UNCONNECTABLE : Messages.JVMBrowserView_CONNECTION_STATE_NOT_CONNECTED));
            }
        }
        return super.getToolTipText(element);
    }

    private static String buildTooltip(String oldString, String title, String value) {
        if (value == null) {
            return oldString;
        }
        String newLine = String.valueOf(title) + ": " + value;
        newLine = newLine.length() > 150 ? String.valueOf(newLine.substring(0, 150)) + "..." : newLine;
        return oldString == null ? newLine : String.valueOf(oldString) + "\n" + newLine;
    }
}

