/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.browser.remoteagent;

import com.oracle.jmc.browser.attach.LocalJVMToolkit;
import com.oracle.jmc.browser.attach.Messages;
import com.oracle.jmc.browser.remoteagent.RemoteJMXAgentWizardPage;
import com.oracle.jmc.rjmx.IServerHandle;
import com.oracle.jmc.rjmx.internal.ServerToolkit;
import com.oracle.jmc.ui.misc.DialogToolkit;
import java.util.Properties;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class RemoteJMXAgentWizard
extends Wizard {
    private final Boolean agentStarted;
    private final Properties currentSettings;
    private final String serverName;
    private final String pid;

    public RemoteJMXAgentWizard(IServerHandle serverHandle, Boolean agentStarted, Properties currentSettings) {
        this.serverName = ServerToolkit.getDisplayName((IServerHandle)serverHandle);
        this.pid = String.valueOf(ServerToolkit.getPid((IServerHandle)serverHandle));
        this.agentStarted = agentStarted;
        this.currentSettings = currentSettings;
        this.setWindowTitle(RemoteJMXAgentWizardPage.getTitle(agentStarted, this.serverName));
    }

    public void addPages() {
        this.addPage((IWizardPage)new RemoteJMXAgentWizardPage(this.serverName, this.agentStarted, this.currentSettings));
    }

    public boolean performFinish() {
        String command = ((RemoteJMXAgentWizardPage)this.getPage("browser.attach.management.agent.settings.wizard.page")).getCommand();
        if (command != null) {
            try {
                String result = LocalJVMToolkit.executeCommandForPid((String)this.pid, (String)command, (boolean)true);
                if (result.length() != 0) {
                    DialogToolkit.showWarning((Shell)this.getShell(), (String)Messages.RemoteJMXStarterAction_REMOTE_JMX_AGENT_RESULT_TITLE, (String)NLS.bind((String)Messages.RemoteJMXStarterAction_REMOTE_JMX_AGENT_RESULT_DESCRIPTION, (Object[])new String[]{this.serverName, command, result}));
                }
                return true;
            }
            catch (Throwable e) {
                DialogToolkit.showException((Shell)this.getShell(), (String)Messages.RemoteJMXStarterAction_REMOTE_JMX_AGENT_PROBLEM_TITLE, (String)NLS.bind((String)Messages.RemoteJMXStarterAction_REMOTE_JMX_AGENT_PROBLEM_DESCRIPTION, (Object)this.serverName, (Object)command), (Throwable)e);
            }
        }
        return false;
    }
}

