/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.greychart.ui.views;

import com.oracle.jmc.greychart.ui.messages.internal.Messages;
import java.util.LinkedHashMap;
import java.util.Map;
import se.hirt.greychart.TickDensity;

public enum TickDensityName {
    VARIABLE("variable", Messages.TICK_DENSITY_NAME_VARIABLE),
    VERY_DENSE("veryDense", Messages.TICK_DENSITY_NAME_VERY_DENSE),
    DENSE("dense", Messages.TICK_DENSITY_NAME_DENSE),
    NORMAL("normal", Messages.TICK_DENSITY_NAME_NORMAL),
    SPARSE("sparse", Messages.TICK_DENSITY_NAME_SPARSE),
    VERY_SPARSE("verySparse", Messages.TICK_DENSITY_NAME_VERY_SPARSE);

    final String key;
    private final String readableName;

    private TickDensityName(String key, String name) {
        this.key = key;
        this.readableName = name;
    }

    public static TickDensityName toObject(String key) {
        TickDensityName[] tickDensityNameArray = TickDensityName.values();
        int n = tickDensityNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            TickDensityName s = tickDensityNameArray[n2];
            if (s.key.equals(key)) {
                return s;
            }
            ++n2;
        }
        return VARIABLE;
    }

    public static String getReadableName(TickDensity density) {
        TickDensityName[] tickDensityNameArray = TickDensityName.values();
        int n = tickDensityNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            TickDensityName tickDensityName = tickDensityNameArray[n2];
            if (TickDensityName.toDensity(tickDensityName).equals((Object)density)) {
                return tickDensityName.readableName;
            }
            ++n2;
        }
        return TickDensityName.VARIABLE.readableName;
    }

    public static TickDensity toDensity(String key) {
        return TickDensityName.toDensity(TickDensityName.toObject(key));
    }

    public static TickDensity toDensity(TickDensityName tickDensityName) {
        switch (tickDensityName) {
            case VERY_DENSE: {
                return TickDensity.VERY_DENSE;
            }
            case DENSE: {
                return TickDensity.DENSE;
            }
            case NORMAL: {
                return TickDensity.NORMAL;
            }
            case SPARSE: {
                return TickDensity.SPARSE;
            }
            case VERY_SPARSE: {
                return TickDensity.VERY_SPARSE;
            }
        }
        return TickDensity.VARIABLE;
    }

    public static Map<String, String> createNameKeyMap() {
        LinkedHashMap<String, String> styleMap = new LinkedHashMap<String, String>();
        styleMap.put(TickDensityName.VARIABLE.key, TickDensityName.VARIABLE.readableName);
        styleMap.put(TickDensityName.VERY_DENSE.key, TickDensityName.VERY_DENSE.readableName);
        styleMap.put(TickDensityName.DENSE.key, TickDensityName.DENSE.readableName);
        styleMap.put(TickDensityName.NORMAL.key, TickDensityName.NORMAL.readableName);
        styleMap.put(TickDensityName.SPARSE.key, TickDensityName.SPARSE.readableName);
        styleMap.put(TickDensityName.VERY_SPARSE.key, TickDensityName.VERY_SPARSE.readableName);
        return styleMap;
    }
}

