/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.mbeanbrowser.tree;

import com.oracle.jmc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.oracle.jmc.console.ui.mbeanbrowser.messages.internal.Messages;
import com.oracle.jmc.core.DefaultTreeNode;
import com.oracle.jmc.rjmx.ui.RJMXUIPlugin;
import java.io.IOException;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;

public class UnregisterMBeanAction
extends SelectionProviderAction {
    private static final String[] SYSTEM_MBEAN_DOMAINS = new String[]{"java.lang", "java.nio", "JMImplementaion", "java.util.logging", "java.nio", "com.sun.management"};
    private final MBeanServerConnection mbeanServer;
    private final TreeViewer viewer;

    public UnregisterMBeanAction(MBeanServerConnection server, TreeViewer viewer) {
        super((ISelectionProvider)viewer, Messages.UNREGISTER_MBEAN_ACTION_LABEL);
        this.mbeanServer = server;
        this.viewer = viewer;
        this.setDescription(Messages.UNREGISTER_MBEAN_ACTION_DESCRIPTION);
        this.setEnabled(false);
    }

    public void selectionChanged(IStructuredSelection selection) {
        boolean enabled = false;
        for (Object o : this.getStructuredSelection().toList()) {
            if (!(o instanceof DefaultTreeNode) || this.getObjectName((DefaultTreeNode)o) == null) continue;
            enabled = true;
            break;
        }
        this.setEnabled(enabled);
    }

    private ObjectName getObjectName(DefaultTreeNode node) {
        return (ObjectName)node.getAdapter(ObjectName.class);
    }

    public void run() {
        for (Object o : this.getStructuredSelection().toList()) {
            ObjectName mbean;
            if (!(o instanceof DefaultTreeNode) || (mbean = this.getObjectName((DefaultTreeNode)o)) == null || !this.checkUnregisterMBean(mbean)) continue;
            this.unregisterMBean(mbean);
            this.viewer.refresh();
        }
    }

    private void unregisterMBean(ObjectName mbean) {
        try {
            this.mbeanServer.unregisterMBean(mbean);
        }
        catch (InstanceNotFoundException e) {
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, "Instance to delete not found: " + mbean, e);
        }
        catch (MBeanRegistrationException e) {
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, "Exception during preDeregister of MBean: " + mbean, e);
        }
        catch (IOException e) {
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, "Communication problem talking to MBean server: " + mbean, e);
        }
    }

    private boolean checkUnregisterMBean(ObjectName mbean) {
        if (this.isSystemMBean(mbean)) {
            return this.checkUnregisterSystemMBean(mbean);
        }
        return this.checkUnregisterOtherMBean(mbean);
    }

    private boolean isSystemMBean(ObjectName mbean) {
        String domain = mbean.getDomain();
        if (domain != null) {
            String[] stringArray = SYSTEM_MBEAN_DOMAINS;
            int n = SYSTEM_MBEAN_DOMAINS.length;
            int n2 = 0;
            while (n2 < n) {
                String systemDomain = stringArray[n2];
                if (domain.equals(systemDomain)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean checkUnregisterSystemMBean(ObjectName mbean) {
        return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.UNREGISTER_SYSTEM_MBEAN_TITLE, (String)NLS.bind((String)Messages.UNREGISTER_SYSTEM_MBEAN_LABEL, (Object)mbean));
    }

    private boolean checkUnregisterOtherMBean(ObjectName mbean) {
        if (!this.readUnregisterMBeanSetting()) {
            return true;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.UNREGISTER_MBEAN_TITLE, (String)NLS.bind((String)Messages.UNREGISTER_MBEAN_LABEL, (Object)mbean), (String)Messages.UNREGISTER_MBEAN_TOGGLE_LABEL, (boolean)true, null, null);
        if (dialog.getReturnCode() == 0) {
            this.storeUnregisterMBeanSetting(dialog.getToggleState());
            return true;
        }
        return false;
    }

    private boolean readUnregisterMBeanSetting() {
        return RJMXUIPlugin.getDefault().getPreferenceStore().getBoolean("console.ui.mbeanbrowser.ask_before_mbean_deregister");
    }

    private void storeUnregisterMBeanSetting(boolean removeMBean) {
        RJMXUIPlugin.getDefault().getPreferenceStore().setValue("console.ui.mbeanbrowser.ask_before_mbean_deregister", removeMBean);
    }
}

