/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.mbeanbrowser.tree;

import com.oracle.jmc.console.ui.actions.MBeanAutomaticRefreshAction;
import com.oracle.jmc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.oracle.jmc.console.ui.mbeanbrowser.tab.FeatureSectionPart;
import com.oracle.jmc.console.ui.mbeanbrowser.tree.AddMBeanAction;
import com.oracle.jmc.console.ui.mbeanbrowser.tree.UnregisterMBeanAction;
import com.oracle.jmc.core.AdapterUtil;
import com.oracle.jmc.core.ITreeNode;
import com.oracle.jmc.rjmx.subscription.IMBeanHelperService;
import com.oracle.jmc.rjmx.subscription.IMBeanServerChangeListener;
import com.oracle.jmc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.oracle.jmc.rjmx.ui.internal.MBeanTreeLabelProvider;
import com.oracle.jmc.rjmx.ui.internal.MBeanTreeSorter;
import com.oracle.jmc.rjmx.ui.internal.TreeNodeBuilder;
import com.oracle.jmc.rjmx.ui.internal.TreeNodeFilter;
import com.oracle.jmc.ui.Messages;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import com.oracle.jmc.ui.misc.IRefreshable;
import com.oracle.jmc.ui.misc.MCLayoutFactory;
import com.oracle.jmc.ui.misc.MCSectionPart;
import com.oracle.jmc.ui.misc.TreeStructureContentProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MBeanTreeSectionPart
extends MCSectionPart
implements MBeanPropertiesOrderer.IMBeanPropertiesOrderChangedListener {
    public static final String MBEANBROWSER_MBEAN_TREE_NAME = "mbeanbrowser.MBeanTree";
    private final TreeViewer viewer;
    private final MBeanServerConnection mbeanServer;
    private final IMBeanHelperService mbeanService;
    private final IRefreshable viewerRefresher = new IRefreshable(){

        public boolean refresh() {
            try {
                final ITreeNode[] nodes = MBeanTreeSectionPart.this.buildTreeModel();
                DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!MBeanTreeSectionPart.this.getSection().isDisposed()) {
                            TreeItem newTopItem;
                            Object[] expandedElements = MBeanTreeSectionPart.this.viewer.getExpandedElements();
                            TreeItem topItem = MBeanTreeSectionPart.this.viewer.getTree().getTopItem();
                            Object topObject = topItem != null ? topItem.getData() : null;
                            MBeanTreeSectionPart.this.viewer.getControl().setRedraw(false);
                            MBeanTreeSectionPart.this.viewer.setInput((Object)nodes);
                            MBeanTreeSectionPart.this.viewer.setExpandedElements(expandedElements);
                            if (topObject != null && (newTopItem = this.findItem(topObject, MBeanTreeSectionPart.this.viewer.getTree().getItems())) != null) {
                                MBeanTreeSectionPart.this.viewer.getTree().setTopItem(newTopItem);
                            }
                            MBeanTreeSectionPart.this.viewer.getControl().setRedraw(true);
                            MBeanTreeSectionPart.this.viewer.getControl().redraw();
                        }
                    }

                    private TreeItem findItem(Object object, TreeItem[] items) {
                        if (items == null) {
                            return null;
                        }
                        TreeItem[] treeItemArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            if (object.equals(item.getData())) {
                                return item;
                            }
                            TreeItem childItem = this.findItem(object, item.getItems());
                            if (childItem != null) {
                                return childItem;
                            }
                            ++n2;
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    };
    private final MBeanAutomaticRefreshAction refreshAction = new MBeanAutomaticRefreshAction(this.viewerRefresher);

    public MBeanTreeSectionPart(Composite parent, FormToolkit toolkit, MBeanServerConnection mbeanServer, String guid, IMBeanHelperService mbeanService) {
        super(parent, toolkit, 256);
        this.mbeanServer = mbeanServer;
        this.mbeanService = mbeanService;
        this.getSection().setText(com.oracle.jmc.console.ui.mbeanbrowser.messages.internal.Messages.MBeanTreeSectionPart_MBEAN_TREE_TITLE_TEXT);
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        Composite filterComposite = toolkit.createComposite(body);
        toolkit.paintBordersFor(filterComposite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        filterComposite.setLayout((Layout)layout);
        Label filterLabel = toolkit.createLabel(filterComposite, com.oracle.jmc.console.ui.mbeanbrowser.messages.internal.Messages.MBeanTreeSectionPart_MBEAN_TREE_FILTER_TEXT);
        filterLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        Text filterText = toolkit.createText(filterComposite, "");
        filterText.setLayoutData((Object)new GridData(4, 4, true, false));
        filterText.setToolTipText(Messages.SEARCH_KLEENE_OR_REGEXP_TOOLTIP);
        filterComposite.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)false));
        this.viewer = this.createViewer(body, toolkit);
        this.viewer.getControl().setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)true));
        TreeNodeFilter.install((TreeViewer)this.viewer, (Text)filterText, (boolean)false);
        ITreeNode[] nodes = this.buildTreeModel();
        this.viewer.setInput((Object)nodes);
        this.getMCToolBarManager().add((IAction)new AddMBeanAction(mbeanServer, guid));
        this.getMCToolBarManager().add((IAction)this.refreshAction);
        mbeanService.addMBeanServerChangeListener((IMBeanServerChangeListener)this.refreshAction);
        this.setupDoubleClickListener();
    }

    public void dispose() {
        MBeanPropertiesOrderer.removePropertiesOrderChangedListener((MBeanPropertiesOrderer.IMBeanPropertiesOrderChangedListener)this);
        this.mbeanService.removeMBeanServerChangeListener((IMBeanServerChangeListener)this.refreshAction);
        super.dispose();
    }

    public void selectDefaultBean() {
        try {
            ObjectName bean = ObjectName.getInstance("java.lang", "type", "OperatingSystem");
            ArrayList<ITreeNode> search = new ArrayList<ITreeNode>();
            search.addAll(Arrays.asList((ITreeNode[])this.viewer.getInput()));
            while (!search.isEmpty()) {
                ITreeNode node = (ITreeNode)search.remove(0);
                if (node.getUserData() instanceof MBeanPropertiesOrderer.PropertyWithMBean && bean.equals(((MBeanPropertiesOrderer.PropertyWithMBean)node.getUserData()).getBean())) {
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
                    return;
                }
                ITreeNode[] children = node.getChildren();
                if (children == null) continue;
                search.addAll(Arrays.asList(children));
            }
            MBeanBrowserPlugin.getDefault().getLogger().warning("Couldn't find " + bean + " in MBean tree");
        }
        catch (Exception e) {
            e.printStackTrace();
            MBeanBrowserPlugin.getDefault().getLogger().warning("Failed to select OperatingSystem bean: " + e);
        }
    }

    private TreeViewer createViewer(Composite parent, FormToolkit formToolkit) {
        Tree tree = formToolkit.createTree(parent, 0);
        tree.setData("name", (Object)MBEANBROWSER_MBEAN_TREE_NAME);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
        viewer.setComparator((ViewerComparator)new MBeanTreeSorter());
        viewer.setLabelProvider((IBaseLabelProvider)new MBeanTreeLabelProvider(null));
        MBeanPropertiesOrderer.addPropertiesOrderChangedListener((MBeanPropertiesOrderer.IMBeanPropertiesOrderChangedListener)this);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        MCContextMenuManager mm = MCContextMenuManager.create((Control)tree);
        mm.add((IAction)new UnregisterMBeanAction(this.mbeanServer, viewer));
        return viewer;
    }

    public void addMBeanListener(final FeatureSectionPart infoPart) {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                ObjectName converted = (ObjectName)AdapterUtil.getAdapter((Object)selected, ObjectName.class);
                if (converted != null) {
                    infoPart.showBean(converted);
                }
            }
        });
    }

    private void setupDoubleClickListener() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ITreeNode elementNode = (ITreeNode)selection.getFirstElement();
                if (elementNode.getAdapter(ObjectName.class) == null) {
                    MBeanTreeSectionPart.this.viewer.setExpandedState((Object)elementNode, !MBeanTreeSectionPart.this.viewer.getExpandedState((Object)elementNode));
                }
            }
        });
    }

    public void propertiesOrderChanged(PropertyChangeEvent e) {
        if (!e.getProperty().equals("console.ui.mbeanbrowser.showCompressedPaths")) {
            this.viewerRefresher.refresh();
        }
    }

    private ITreeNode[] buildTreeModel() {
        try {
            Set ons = this.mbeanService.getMBeanNames();
            TreeNodeBuilder root = new TreeNodeBuilder();
            for (ObjectName bean : ons) {
                MBeanPropertiesOrderer.Property[] properties;
                TreeNodeBuilder node = root.getUniqueChild((Object)bean.getDomain());
                MBeanPropertiesOrderer.Property[] propertyArray = properties = MBeanPropertiesOrderer.getOrderedProperties((ObjectName)bean);
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    MBeanPropertiesOrderer.Property p = propertyArray[n2];
                    node = node.get((Object)p.getStringRepresentation());
                    if (p instanceof MBeanPropertiesOrderer.PropertyWithMBean || node.getValue() == null) {
                        node.setValue((Object)p);
                    }
                    ++n2;
                }
            }
            return root.getChildren(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

