/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.mbeanbrowser.metadata;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.util.TypeHandling;
import com.oracle.jmc.console.ui.mbeanbrowser.metadata.ConstructorContentProvider;
import com.oracle.jmc.console.ui.mbeanbrowser.metadata.Messages;
import com.oracle.jmc.ui.column.ColumnBuilder;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.ColumnMenusFactory;
import com.oracle.jmc.ui.column.IColumn;
import com.oracle.jmc.ui.column.TableSettings;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import com.oracle.jmc.ui.misc.MementoToolkit;
import java.util.Arrays;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public final class ConstructorSectionPart {
    private final ColumnManager columnManager;

    public ConstructorSectionPart(Composite parent, FormToolkit toolkit, IMemento state) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.ConstructorSectionPart_CONSTRUCTORS_TITLE_TEXT);
        Tree tree = new Tree((Composite)section, 68354);
        section.setClient((Control)tree);
        TreeViewer viewer = new TreeViewer(tree);
        IColumn itemColumn = new ColumnBuilder(Messages.ConstructorSectionPart_ITEM_NAME_TEXT, "item", new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MBeanConstructorInfo) {
                    return ((MBeanConstructorInfo)element).getName();
                }
                if (element instanceof MBeanParameterInfo) {
                    MBeanParameterInfo parameter = (MBeanParameterInfo)element;
                    return String.valueOf(TypeHandling.simplifyType((String)parameter.getType())) + ' ' + parameter.getName();
                }
                return super.getText(element);
            }
        }).description(Messages.ConstructorSectionPart_ITEM_DESCRIPTION_TEXT).build();
        IColumn descColumn = new ColumnBuilder(Messages.ConstructorSectionPart_DESCRIPTION_NAME_TEXT, "description", new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MBeanFeatureInfo) {
                    return ((MBeanFeatureInfo)element).getDescription();
                }
                return super.getText(element);
            }
        }).description(Messages.ConstructorSectionPart_DESCRIPTION_DESCRIPTION_TEXT).build();
        this.columnManager = ColumnManager.build((TreeViewer)viewer, Arrays.asList(itemColumn, descColumn), (TableSettings)TableSettings.forState((IState)MementoToolkit.asState((IMemento)state)));
        viewer.setContentProvider((IContentProvider)new ConstructorContentProvider());
        viewer.setAutoExpandLevel(-1);
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnManager, (MCContextMenuManager)MCContextMenuManager.create((Control)tree));
    }

    public void saveState(IMemento state) {
        this.columnManager.getSettings().saveState(MementoToolkit.asWritableState((IMemento)state));
    }

    public void setMBeanInfo(MBeanInfo mbeanInfo) {
        this.columnManager.getViewer().setInput((Object)mbeanInfo);
    }
}

